
Когда мы работаем со строками в программировании, из них регулярно приходится извлекать некую часть. Например, нам нужно выяснить, присутствует ли меньшая строка внутри большей. В этом уроке мы разберемся, как это сделать.

**Подстрока** — это некоторая часть строки, которую нужно найти и извлечь.

Представим, что у нас есть дата в таком формате: *12-08-2034*. Нам нужно извлечь из нее подстроку, в которую входит только год.

Если подумать логически, то нужно посчитать индекс символа, с которого начинается год, и затем извлечь четыре символа. Индексы в строке начинаются с нуля, значит, первый символ года доступен по индексу 6, а последний символ — по индексу 9. Проверим:

```python
value = '12-08-2034'

print(value[6])  # => 2
print(value[9])  # => 4
```

Зная эти индексы, мы можем воспользоваться срезами и получить нужную подстроку:

```python
value = '12-08-2034'

year = value[6:10]
print(year)  # => 2034
```

**Срезы для строк** в Python — это механизм, с помощью которого извлекается подстрока по указанным параметрам. В примере выше мы взяли подстроку с 6 индекса по 10 индекс, не включая, то есть с 6 по 9 включительно. Формула выглядит так:

```python
str[начальный индекс:конечный индекс]

# Пара примеров
value = '01-12-9873'

# Срез строки это всегда строка,
# даже если внутри строки было число.
value[1:2]  # '1'
value[3:5]  # '12'
```

Срезы — механизм с большим количеством вариаций. Например, если не указать вторую границу, то извлечение произойдет до конца строки. То же самое с первой границей — началом строки:

```python
value = 'Hexlet'
value[3:]  # 'let'
value[:3]  # 'Hex'
```

Можно указать даже отрицательные индексы. В таком случае отсчет идет с обратной стороны:

```python
value = 'Hexlet'
# Правая граница отрицательная. Считаем -1 от конца строки
value[3:-1]  # 'le'
# Левая граница отрицательная. Считаем -5 от конца строки
value[-5:3]  # 'ex'
```

У срезов два обязательных параметра, но иногда используется и третий.

У срезов есть третий необязательный параметр — **шаг извлечения**. По умолчанию он равен единице, но мы можем его изменить:

```python
value = 'Hexlet'
value[1:5:2]  # el
# 1:5 это 'exle'
# шаг 2 это каждый второй, то есть 'e' и 'l'
```

Все это можно комбинировать с открытыми границами, то есть без указания начала или конца:

```python
value = 'Hexlet'
value[:5:2]  # 'Hxe'
value[1::2]  # 'elt'
```

Шаг может быть отрицательным, в таком случае он берется с конца. Из этого вытекает самый популярный способ использования шага — **переворот строки**:

```python
value = 'Hexlet'
# Пропускаем обе границы
value[::-1]  # 'telxeH'
```

Если используется отрицательный шаг, и элементы среза извлекаются в обратном порядке — тогда и границы среза тоже нужно указывать в обратном порядке. Первой указывается правая граница среза, второй — левая:

```python
value = 'Hexlet'
# Символ с индексом 1 не будет включен в подстроку
value[4:1:-1]  # 'elx'
```

Срезы можно указывать не только через числа, но и с использованием переменных:

```python
value = 'Hexlet'
start = 1
end = 5
value[start:end]  # 'exle'
```

https://replit.com/@hexlet/python-basics-advanced-strings-slices

Соберем все вместе:

```python
value = 'Hexlet'
value[::] = 'Hexlet'  # Вся строка
value[:] = 'Hexlet'  # Вся строка
value[::2] = 'Hxe'  # Четные по порядку символы
value[1::2] = 'elt'  # Нечетные по порядку символы
value[::-1] = 'telxeH'  # Вся строка в обратном порядке
value[5:] = 't'  # Строка, начиная с шестого символа
value[:5] = 'Hexle'  # Строка до шестого символа
value[-2:1:-1] = 'elx'  # Все символы с предпоследнего до третьего включительно, в обратном порядке

# Во всех случаях выборки от большего индекса к меньшему нужно указывать шаг
```

Как видите, срезы способны на многое. Не переживайте, если прямо сейчас не запомните все эти комбинации — это нормально. Со временем вы научитесь их использовать, не подглядывая в документацию.
