
When we work with strings in programming, we regularly have to extract some part of them. For example, we need to figure out if a smaller string is present inside a larger one. In this lesson, we will figure out how to do that.

**Substring** is some part of the string to be found and extracted.

Suppose we have a date in this format: *12-08-2034*. We need to extract from it a substring, which includes only the year.

If you think logically, you need to count the index of the character with which the year begins, and then extract the four characters. The indexes in the string start from zero, so the first character of the year is available by index 6, and the last character by index 9. Check:

```python
value = '12-08-2034'

print(value[6])  # => 2
print(value[9])  # => 4
```

Knowing these indices, we can use slices and get the desired substring:

```python
value = '12-08-2034'

year = value[6:10]
print(year)  # => 2034
```

**String Slices** in Python is a mechanism by which you extract a substring by specified parameters. In the example above, we took the substring from index 6 through index 10, not including, that is, 6 through 9 inclusive. The formula looks like this:

```python
str[start index:end index]

# A couple of examples
value = '01-12-9873'

# A line cut is always a line,
# even if there was a number inside the string.
value[1:2]  # '1'
value[3:5]  # '12'
```

Cuts are a mechanism with many variations. For example, if you do not specify the second boundary, the extraction will happen before the end of the string. It is the same with the first boundary - the beginning of the string:

```python
value = 'Hexlet'
value[3:]  # 'let'
value[:3]  # 'Hex'
```

You can even specify negative indices. In this case the counting goes from the reverse side:

```python
value = 'Hexlet'
# The right boundary is negative. Count -1 from the end of the line
value[3:-1]  # 'le'
# The left boundary is negative. We count -5 from the end of the line
value[-5:3]  # 'ex'
```

Slices have two mandatory parameters, but sometimes a third is used.

Slices have a third optional parameter - **extraction step**. By default it is one, but we can change it:

```python
value = 'Hexlet'
value[1:5:2]  # el
# 1:5 это 'exle'
# step 2 is every second, that is, 'e' and 'l'
```

All of these can be combined with open boundaries, that is, without specifying the beginning or end:

```python
value = 'Hexlet'
value[:5:2]  # 'Hxe'
value[1::2]  # 'elt'
```

The step can be negative, in which case it is taken from the end. From this follows the most popular way to use the step - **reverse the string**:

```python
value = 'Hexlet'
# Skipping both borders
value[::-1]  # 'telxeH'
```

If a negative step is used, and the slice elements are extracted in reverse order, then the slice boundaries should also be specified in reverse order. The right slice boundary is specified first, and the left one is specified second:

```python
value = 'Hexlet'
# The character with index 1 will not be included in the substring
value[4:1:-1]  # 'elx'
```

The cuts can be specified not only through numbers, but also using variables:

```python
value = 'Hexlet'
start = 1
end = 5
value[start:end]  # 'exle'
```

As you can see, slices can do a lot. Don't worry if you don't memorize all these combinations right now-it's okay. Over time, you'll learn how to use them without having to peek at the documentation.
