
Иногда нужно получить один символ из строки. Например, если сайт знает имя и фамилию пользователя, и в какой-то момент требуется вывести эту информацию в формате *A. Ivanov*. Для этого компьютеру потребуется взять первый символ из имени. В Python есть подходящая операция, которую мы изучим сегодня.

Представим, что из имени Alexander нужно вывести на экран только первую букву. Это выглядит так:

```python
first_name = 'Alexander'

print(first_name[0])  # => A
```

Операция с квадратными скобками с цифрой извлекает элемент по **индексу** — позицией символа внутри строки. Индексы начинаются с 0 почти во всех языках программирования. Поэтому, чтобы получить первый символ, нужно указать индекс `0`. Индекс последнего элемента равен длине строки минус единица. Обращение к индексу за пределами строки приведет к ошибке:

```python
# Длина строки 9, поэтому последний индекс — это 8
first_name = 'Alexander'

print(first_name[8])  # => r

print(first_name[9])
IndexError: string index out of range
```

Чтобы лучше закрепить новые знания, посмотрите на код ниже и подумайте, что он выдаст:

```python
magic = '\nyou'
print(magic[1])  # => ?
```

Бывают и нестандартные ситуации. Например, нужно вывести элемент из конца, причем из выражения с большим количеством символов. В этом случае можно воспользоваться отрицательным индексом, который облегчит работу программиста.

Допустимо использовать отрицательные индексы. В этом случае идет обращение к символам, начиная с конца строки. `-1` — индекс последнего символа, `-2` — предпоследнего и так далее. В отличие от прямой индексации, обратный отсчет идет от `-1`:

```python
first_name = 'Alexander'

print(first_name[-1])  # => r
```

Индексом может быть не только конкретное число, но и значение переменной. Посмотрите на пример ниже. Здесь мы записали индекс внутри квадратных скобок не числом, а переменной. Такой код приведет к тому же результату — выводу на экран символа *A*:

```python
first_name = 'Alexander'
index = 0

print(first_name[index])  # => A
```

https://replit.com/@hexlet/python-basics-advanced-strings-symbols

Чтобы выводить из выражения лишь некоторые символы, не нужно писать большое количество строк кода — достаточно извлечь элемент с помощью индекса. Также можно пользоваться отрицательным индексом, чтобы легче выводить символы с конца выражения. Далее разберемся, как с помощью этих знаний можно извлекать подстроки из строки.
