
Вы уже знаете, как перенести строку или «слепить» несколько строк, чтобы получить новое выражение. Но в программировании есть альтернативы этих операций. Они повышают читаемость кода и делают его проще в поддержке.

Базовый способ соединения строк — **конкатенация**. С помощью конкатенации строки «суммируются» друг с другом, как в примере ниже:

```python
first_name = 'Joffrey'
greeting = 'Hello'

print(greeting + ", " + first_name + "!")
# => Hello, Joffrey!
```

Конкатенация работает просто, но выглядит не всегда наглядно. Из-за кавычек сложно разглядеть то, каким будет конечный результат. И чем сложнее устроена строка, тем запутаннее она начнет выглядеть. У конкатенации есть альтернатива — **интерполяция**. Вот как это выглядит:

```python
first_name = 'Joffrey'
greeting = 'Hello'

print(f'{greeting}, {first_name}!')
# => Hello, Joffrey!
```

Буква `f` указывает на то, что мы создаем **f-строку** — шаблон, в который с помощью фигурных скобок подставляются значения переменных. На выходе получается обычная строка.

Рассмотрим такой пример:

```python
school = 'Hexlet'

what_is_it = f'{school} - online courses'
print(what_is_it)  # => Hexlet - online courses
```

https://replit.com/@hexlet/python-basics-advanced-strings-interpolation

Почти во всех языках для объединения строк интерполяция предпочтительнее конкатенации. Строка при этом получается склеенная, и внутри нее хорошо просматриваются пробелы и другие символы.

Интерполяция помогает сделать код более понятным для разработчиков. Но это не единственная полезная альтернатива, о которой мы хотели рассказать. Далее в курсе мы разберемся, как объявлять многострочную строку и не использовать `\n`.
