
You already know how to move a string or glue several strings together to get a new expression. But there are alternatives to these operations in programming. They make the code more readable and easier to maintain.

The basic way to join strings is **concatenation**. Using concatenation, the strings are added to each other, as in the example below:

```python
first_name = 'Joffrey'
greeting = 'Hello'

print(greeting + ", " + first_name + "!")
# => Hello, Joffrey!
```

Concatenation works simply, but doesn't always look so visually clear. The quotation marks make it difficult to see what the end result will be. And the more complex the string is, the more confusing it will start to look. Concatenation has an alternative: **interpolation**. This is what it looks like:

```python
first_name = 'Joffrey'
greeting = 'Hello'

print(f'{greeting}, {first_name}!')
# => Hello, Joffrey!
```

The letter `f` indicates that we are creating an **f-string**, a pattern into which the value of variables is substituted with the help of curly brackets. The output is a normal string.

Consider this example:

```python
school = 'Hexlet'

what_is_it = f'{school} - online courses'
print(what_is_it)  # => Hexlet - online courses
```

In almost all languages, interpolation is preferable to concatenation for combining strings. This produces strings that are stuck together, and spaces and characters are visible inside it.

Interpolation helps make code clearer to developers. But that's not the only useful alternative we want to talk about. Later in the course, we'll look at how to declare a multiline string without using `\n`.
