
Возьмем пример программы, которая считает курс валют:

```python
euros_count = 1000
dollars_count = euros_count * 1.25  # 1250.0
rubles_count = dollars_count * 60   # 75000.0

print(rubles_count)
```

С точки зрения профессиональной разработки, такой код не соответствует «лучшим практикам» — best practices.

В этом примере сложно понять, что значат числа `60` и `1.25`. Представьте, что вам придется разбираться в этом коде через месяц или через год — это будет сложно. Также сложно будет программисту, который не видел код ранее.

В нашем примере контекст легко восстановить, потому что переменные названы грамотно. Но в реальных проектах код значительно сложнее, поэтому догадаться до смысла чисел зачастую невозможно.

Проблема кроется в «магических числах» — magic numbers. Это числа, происхождение которых невозможно понять с первого взгляда — приходится глубоко вникать в то, что происходит в коде.

Чтобы предотвратить проблему, нужно создавать переменные с правильными именами. Так все встанет на свои места:

```python
dollars_per_euro = 1.25
rubles_per_dollar = 60

euros_count = 1000
dollars_count = euros_count * dollars_per_euro     # 1250.0
rubles_count = dollars_count * rubles_per_dollar  # 75000.0

print(rubles_count)
```

В этой программе:

* Используется именование snake_case
* Две новые переменные отделяются от последующих вычислений пустой строчкой. Эти переменные имеют смысл и без вычислений, поэтому такое отделение уместно, потому что повышает читаемость
* Получился хорошо именованный и структурированный код, но он длиннее прошлой версии. Так часто бывает — это нормально, ведь код должен быть читабельным

Магические числа и непонятные именования переменных не ломают код, но делают его менее читабельным.

Нужно понимать, что компьютер в любом случае выполнит заданное вычисление. Однако другой программист будет читать код и ничего не поймет — это усложнит работу. Правильное именование переменных — половина успеха анализа кода.
