
`greeting` — пример простого имени, но не все имена так просты. Часто они включают в себя несколько слов: например, «имя пользователя». В разных языках применяются разные стили кодирования, и имя переменной будет отличаться.

В именовании переменных можно выделить три основных подхода, которые иногда комбинируют друг с другом. Все эти подходы проявляют себя, когда имя переменной состоит из нескольких слов:

* **kebab-case** — составные части переменной разделяются дефисом (`my-super-var`)
* **snake\_case** — для разделения используется подчеркивание (`my_super_var`)
* **CamelCase** — каждое слово в переменной пишется с заглавной буквы (`MySuperVar`)

Переменные в Python именуются в стиле `snake_case`: слова записываются строчными буквами и разделяются символом подчеркивания `_`. Чтобы разобраться подробнее, можете изучить раздел [«Как называть переменные»](https://peps.python.org/pep-0008/#naming-conventions) в стандарте PEP8.

На [Хекслете](https://ru.hexlet.io/) мы начинаем работать с линтерами почти с самого начала.

Далее посмотрим пример плохих практик и разберем, почему их стоит избегать.
