
`greeting` - es un ejemplo de nombre simple, pero no todos los nombres son tan simples como ese. A menudo, incluyen varias palabras, como "nombre de usuario". En los distintos lenguajes de programación se utilizan diferentes convenciones de codificación, por lo que el nombre de la variable será diferente.

En la nomenclatura de variables, se pueden identificar tres enfoques principales que a veces se combinan entre sí. Todos estos enfoques se aplican cuando el nombre de la variable consta de varias palabras:

* **kebab-case** - las partes de la variable se separan con guiones (`my-super-var`)
* **snake\_case** - se utiliza un guión bajo para separar (`my_super_var`)
* **CamelCase** - cada palabra en la variable se escribe con mayúscula (`MySuperVar`)

En Python, las variables se nombran en estilo `snake_case`: las palabras se escriben en minúsculas y se separan con el carácter de guión bajo `_`. Para obtener más información, puedes consultar la sección [«Cómo nombrar variables»](https://peps.python.org/pep-0008/#naming-conventions) en el estándar PEP8.

En [Hexlet](https://ru.hexlet.io/), comenzamos a trabajar con linters casi desde el principio.

A continuación, veremos ejemplos de malas prácticas y analizaremos por qué se deben evitar.
