
`greeting` is an example of a simple name, but not all names are that simple. Often they include several words: for example, «username». Different languages have different naming styles for variables.

Three main variable naming conventions are sometimes combined. These conventions apply to variable names consisting of several words:

* **kebab-case** — the constituent words of the variable are separated by a hyphen (`my-super-var`)
* **snake\_case** — underscores (`my_super_var`) are used to separate the parts
* **CamelCase** — each word in the variable is capitalized (`MySuperVar`)

Variables in Python are generally named in the `snake_case` style; words are written in lowercase letters and separated by an underscore `_`. For more details, you can study the section [«How to name variables»](https://peps.python.org/pep-0008/#naming-conventions) in the PEP8 standard.

At [Hexlet](https://hexlet.io/) we start with linters nigh on straight away.

Next, let's look at an example of bad practices and consider why they should be avoided.
