
Мы уже разобрались, как работать с переменными, чтобы хранить и переиспользовать информацию. Но еще они помогают упрощать сложные вычисления. Например, конвертация валюты или составление нового слова. Рассмотрим, как это делать на практике.

Представим, что нам нужно перевести евро в юани через доллары. Подобные конвертации через промежуточную валюту часто делают банки при покупках за рубежом.

Для начала переведем 50 евро в доллары. Допустим, что один евро — 1.25 долларов:

```python
dollars_count = 50 * 1.25
print(dollars_count)  # => 62.5
```

Здесь в переменную `dollars_count = 50 * 1.25` справа от знака «равно» мы записываем **выражение**. Интерпретатор вычислит результат (`62.5`) и запишет его в переменную.  Интерпретатору не важно, в каком виде записаны данные: `62.5` или `50 * 1.25`. Для него оба варианта — выражения, которые надо вычислить. Он проводит вычисления и приходит к одному и тому же значению — `62.5`.

Любая строка — выражение. Конкатенация строк (склеивание значений переменных) — это тоже выражение. Когда интерпретатор видит выражение, он обрабатывает его и генерирует результат — **значение выражения**.

Вот несколько примеров выражения. В комментариях справа от каждого выражения записаны итоговые значения:

```python
62.5             # 62.5
50 * 1.25        # 62.5
120 / 10 * 2     # 24.0
int('100')       # 100

'hello'          # hello
'Good' + 'will'  # Goodwill
```

В тех местах, где ожидается выражение, можно поставить любое вычисление. Оно может быть не только математическим, но и строковым — как конкатенация. Программа все равно останется работоспособной.

Программы состоят из множества комбинаций выражений. Основываясь на сказанном выше, подумайте, сработает ли такой код:

```python
who = "dragon's " + 'mother'
print(who)
```

Такой код выведет на экран строку `dragon's mother`. Если хотите проверить самостоятельно, запустите код на [repl.it](https://replit.com/languages/python3) и поэкспериментируйте.

С помощью переменных можно записывать еще более сложные вычисления. Вернемся к нашей валютной программе. Запишем стоимость доллара в юанях, как отдельную переменную. Вычислим цену 50 евро в долларах, умножив их на `1.25`. Допустим, что 1 доллар — 6.91 юаней:

```python
yuans_per_dollar = 6.91
dollars_count = 50 * 1.25  # 62.5
yuans_count = dollars_count * yuans_per_dollar  # 431.875

print(yuans_count)
```

Теперь добавим к выводу текст с помощью конкатенации:

```python
yuans_per_dollar = 6.91
dollars_count = 50 * 1.25  # 62.5
yuans_count = dollars_count * yuans_per_dollar  # 431.875

# Функция str() превращает число в строку.
# О таких превращениях будет отдельный урок.
print('The price is ' + str(yuans_count) + ' yuans')
# => The price is 431.875 yuans
```

Любая переменная может быть частью любого выражения. В момент вычисления вместо имени переменной подставляется ее значение.

Интерпретатор вычисляет значение `dollars_count` до того, как эта переменная начнет использоваться в других выражениях. Когда подходит момент использования переменной, Python уже знает значение, потому что вычислил его.

С помощью переменных можно проводить сложные вычисления, а также делать подробный вывод с получившимся значением. Но еще можно получать новые выражения посредством склеивания двух и более значений переменных. За это отвечает конкатенация.
