
Порядок инструкций в коде с переменными имеет огромное значение. Поэтому переменную нужно определить до первого использования. Ниже пример ошибки, которую часто допускают новички:

```python
print(greeting)
greeting = 'Father!'
```

Запуск программы выше завершается с ошибкой `NameError: name 'greeting' is not defined` — это ошибка обращения. Это значит, что в коде используется имя (идентификатор), которое пока не определено. Это говорится в самом тексте ошибки: `'greeting' is not defined`. Кроме неправильного порядка действий, в Python встречаются банальные опечатки в имени переменной. Это происходит и когда переменная используется, и когда ее объявляют.

Количество подобных ошибок можно уменьшить, если использовать правильно настроенный редактор. Он предупреждает о возможных проблемах и подсвечивает переменные, которые используются без объявления.
