
Представьте, что мы задали следующую программу:

```python
x = 'Father!'
print(x)
```

С подобной программой мы уже работали, но сейчас в ней изменилось имя переменной на `x`.

Компьютеру без разницы, как мы именуем ту или иную переменную. Названия важны только людям.  Обычно программисты гораздо чаще читают чужой код, чем пишут свой. Чтобы коллеги смогли с легкостью прочитать и проанализировать ваш код, нужно понятно называть переменные.

Важно придумать понятное название, которое отражает смысл переменной. При этом важно давать такие имена, которые будут понимать без контекста, без изучения окружающего кода.

Существует общепринятое правило: не используйте транслит для имен — только английский язык. Если вы испытываете сложности с английским, то пользуйтесь переводчиком. Со временем, копаясь в чужом коде, вы научитесь правильно именовать переменные.

Среди разработчиков есть шутка: «Названия переменных — это одна из самых сложных вещей в программировании». Придумывать названия и правда сложно. Например, сложно назвать переменную, в которой хранится _количество неоплаченных заказов от клиентов с задолженностью в предыдущем квартале._

Чтобы проверить себя, попробуйте сделать такое задание:

> Придумайте название для переменной, в которой будет храниться *«количество братьев и сестер короля»*.
>
> Запишите его в блокноте или отправьте себе на почту. Не указывайте там ничего, кроме названия переменной. А через несколько уроков мы вернемся к этой теме.
