
Imagine we've set the following program:

```python
x = 'Father!'
print(x)
```

We've worked with a similar program before, but now it's changed the variable name to `x`.

The computer doesn't care what we call a variable. Names are only important to people.  Programmers usually read other people's code much more often than they write their own. To make it easy for your colleagues to read and analyze your code, you need to name your variables clearly.

It's important to come up with a clear name that reflects the idea of the variable. It's important to give names that can be understood without context and without examining the surrounding code.

There is a general rule: Do not use transliteration for names - only English. If you have difficulty with English, use a translator. Over time, by poking around in other people's code, you'll learn how to properly name variables.

There's a joke among developers that naming variables is one of the hardest things in programming. It's really hard to come up with names. For example, it's difficult to name a variable that stores the _number of unpaid orders from customers in arrears in the previous quarter._

Try this task to test yourself:

> Think of a name for the variable that will store _"the number of the king's siblings"_.
>
> Write it down in a notebook or email it to yourself. Don't put anything in there except the name of the variable. And in a few lessons, we'll come back to this topic.
