
Представьте, что нам нужно напечатать на экран фразу *Father!* два раза. Эту задачу можно решить так:

```python
print('Father!')
print('Father!')
```

В простейшем случае так и стоит поступить. Но если фраза *Father!* будет использоваться чаще двух раз, да еще и в разных частях программы, то придется ее везде повторять — это неудобно. Проблемы с таким подходом начнутся, когда понадобится изменить фразу, а такое происходит довольно часто. Нам придется найти все места с этой фразой и выполнить необходимую замену.

А можно поступить по-другому. Чтобы не копировать выражение, достаточно создать с ней переменную:

```python
# greeting - переводится как приветствие
greeting = 'Father!'
print(greeting)
print(greeting)
# => Father!
# => Father!
```

В строчке `greeting = 'Father!'` мы берем переменную с именем `greeting` и присваиваем ей значение `'Father!'`. Переменная указывает на данные, которые в нее записали. Благодаря этому, данные можно использовать многократно и не дублировать их постоянно.

Когда переменная создана, можно ее использовать. Она подставляется в те места, где раньше стояла наша фраза. Когда код выполняется, интерпретатор доходит до строчки `print(greeting)` и подставляет содержимое переменной, а затем выполняет код.

Для имени переменной используется любой набор допустимых символов, к которым относятся буквы английского алфавита, цифры и знак `_`. При этом цифру нельзя ставить в начале. Имена переменных регистрозависимы, то есть имя `hello` и имя `HELLO` — это два разных имени для двух разных переменных. Регистр в Python имеет важное значение, никогда не забывайте про него.

Количество создаваемых переменных неограниченно. Большие программы содержат десятки и сотни тысяч имен переменных. Вот как выглядят две переменные внутри одной программы:

```python
greeting1 = 'Father!'
print(greeting1)
print(greeting1)

greeting2 = 'Mother!'
print(greeting2)
print(greeting2)
```

https://replit.com/@hexlet/python-basics-variables-definition

Чтобы программу было удобно читать, среди программистов принято создавать переменные как можно ближе к тому месту, где они используются. Теперь нужно разобраться, как их изменять.
