
В веб-разработке программы постоянно оперируют строками. Все, что мы видим на сайтах, так или иначе представлено в виде текста. Этот текст чаще всего динамический — то есть он получается из разных частей, которые соединяются вместе.

Чтобы соединить строки, нужно выполнить **конкатенацию**:

```python
# Оператор такой же, как и при сложении чисел,
# но здесь он имеет другой смысл (семантику)
print('Dragon' + 'stone')  # => Dragonstone
```

Склеивание строк всегда происходит в том же порядке, в котором записаны операнды. Левый операнд становится левой частью строки, а правый — правой. Вот еще несколько примеров:

```python
print('Kings' + 'wood')      # => Kingswood
print('Kings' + 'road')      # => Kingsroad
print("King's" + 'Landing')  # => King'sLanding
```

Как видите, строки можно склеивать, даже если их записали с разными кавычками.

Пробел — такой же символ, как и другие, поэтому сколько пробелов поставите в строке, столько и получится в итоговой строке:

```python
# Ставим пробел в левой части
print("King's " + 'Landing')  # => King's Landing

# Ставим пробел в правой части
print("King's" + ' Landing')  # => King's Landing
```

https://replit.com/@hexlet/python-basics-string-concatenation
