
Мы хотим показать вот такой диалог:

```
- Are you hungry?
- Aaaarrrgh!
```

Попробуем вывести на экран строку с таким текстом:

```python
print("- Are you hungry?- Aaaarrrgh!")
# => - Are you hungry?- Aaaarrrgh!
```

Как видите, результат получился не такой, как мы хотели. Строки расположились друг за другом, а не одна ниже другой. Нам нужно как-то сказать интерпретатору «нажать на Enter» — сделать перевод строки после вопросительного знака. Это можно сделать с помощью символа `\n`:

```python
print("- Are you hungry?\n- Aaaarrrgh!")
# => - Are you hungry?
# => - Aaaarrrgh!
```

`\n` — это пример **экранированной последовательности** (escape sequence). Такие последовательности еще называют управляющими конструкциями. Их нельзя увидеть в том же виде, в котором их набрали.

Набирая текст в Word, вы нажимаете на Enter в конце строчки. Редактор при этом ставит в конец строчки специальный невидимый символ, который называется LINE FEED (LF, перевод строчки). В некоторых редакторах можно даже включить отображение невидимых символов. Тогда текст будет выглядеть примерно так:

```
- Привет!¶
- О, привет!¶
- Как дела?
```

Устройство, которое выводит соответствующий текст, учитывает этот символ. Например, принтер при встрече с LF протаскивает бумагу вверх на одну строку, а текстовый редактор переносит весь последующий текст ниже, также на одну строку.

Существует несколько десятков таких невидимых символов, но в программировании часто встречаются всего несколько. Кроме перевода строки, к таким символам относятся:

* табуляция `\t` — разрыв, который получается при нажатии на кнопку Tab
* возврат каретки `\r` — работает только в Windows

Распознать такую управляющую конструкцию в тексте можно по символу `\`. Программисты часто используют перевод строки `\n`, чтобы правильно форматировать текст. Например, напишем такой код:

```python
print("Gregor Clegane\nDunsen\nPolliver\nChiswyck")
```

Тогда на экран выведется:

```
Gregor Clegane
Dunsen
Polliver
Chiswyck
```

Когда работаете с символом перевода, учитывайте следующие моменты:

1. Не важно, что стоит перед или после `\n`: символ или пустая строка. Перевод обнаружится и выполнится в любом случае

2. Строка может содержать только `\n`:

  ```python
  print('Gregor Clegane') # Строка с текстом
  print("\n") # Строка с невидимым символом перевода строки
  print('Dunsen') # Строка с текстом
  ```

  Программа выведет на экран:

  ```
  Gregor Clegane


  Dunsen
  ```

3. В коде последовательность `\n` выглядит как два символа, но с точки зрения интерпретатора — это один специальный символ

4. Если нужно вывести `\n` как текст (два отдельных печатных символа), то можно воспользоваться экранированием — добавить еще один `\` в начале. Последовательность `\\n` отобразится как символы `\` и `n`, которые идут друг за другом:

```python
print("Joffrey loves using \\n")
# => Joffrey loves using \n
```

В Windows для перевода строк по умолчанию используется `\r\n`. Такая комбинация хорошо работает только в Windows, но создает проблемы при переносе в другие системы. Например, когда в команде разработчиков есть пользователи Linux.

Дело в том, что последовательность `\r\n` имеет разную трактовку в зависимости от выбранной кодировки, о чем мы поговорим позже. По этой причине в среде разработчиков принято всегда использовать `\n` без `\r`.

В таком случае перевод строки всегда трактуется одинаково и отлично работает в любой системе. Не забудьте настроить ваш редактор на использование `\n`.
