
В этом уроке мы разберемся, что такое строка и какую роль в коде играют кавычки.

Определить строку довольно просто — это некий набор символов. Представим, что у нас есть такие записи:

```python
'Hello'
'Goodbye'
'G'
' '
''
```

Какие из этих вариантов — строки? На самом деле, все пять вариантов подходят:

* С `'Hello'` и `'Goodbye'` все очевидно — мы уже работали с подобными конструкциями и называли их строками
* `'G'` и `' '` — тоже строки, просто в них всего по одному символу
* `''` — это пустая строка, потому в ней ноль символов

Строкой мы считаем все, что находится внутри кавычек: даже если это пробел, один символ или вообще отсутствие символов.

Выше мы записывали строки в одинарных кавычках, но это не единственный способ. Можно использовать и двойные:

```python
print("Dracarys!")
```

Теперь представьте, что вы хотите напечатать строчку *Dragon's mother*. Апостроф перед буквой **s** — это такой же символ, как одинарная кавычка. Попробуем:

```python
print('Dragon's mother')
# SyntaxError: invalid syntax
```

Такая программа не будет работать. С точки зрения Python строчка началась с одинарной кавычки, а потом закончилась после слова **dragon**. Дальше были символы `s mother` без кавычек — значит, это не строка. А потом была одна открывающая строку кавычка, которая так и не закрылась: `')`. Этот код содержит синтаксическую ошибку — это видно даже по тому, как подсвечен код.

Чтобы избежать этой ошибки, мы используем двойные кавычки. Такой вариант программы сработает верно:

```python
print("Dragon's mother")
```

Теперь интерпретатор знает, что строка началась с двойной кавычки и закончиться должна тоже на двойной кавычке. А одинарная кавычка внутри стала частью строки.

Верно и обратное. Если внутри строки мы хотим использовать двойные кавычки, то саму строку надо делать в одинарных. Причем количество кавычек внутри самой строки неважно.

Теперь представим, что мы хотим создать такую строку:

```python
Dragon's mother said "No"
```

В ней есть и одинарные, и двойные кавычки. Нам нужно каким-то образом указать интерпретатору, что кавычки — это один из символов внутри строки, а не начало или конец строки.

Для этого используют **символ экранирования**: `\` — обратный слэш. Если мы поставим `\` перед кавычкой (одинарной или двойной), то интерпретатор распознает кавычку как обычный символ внутри строки, а не начало или конец строки:

```python
# Экранируем кавычки вокруг No, чтобы интерпретатор
# распознал их как часть строки
print("Dragon's mother said \"No\"")
# => Dragon's mother said "No"
```

Обратите внимание, что в примере выше нам не пришлось экранировать одинарную кавычку (апостроф 's), потому что сама строка создана с двойными кавычками. Если бы строка создавалась с одинарными кавычками, то символ экранирования нужен был бы перед апострофом, но не перед двойными кавычками:

```python
print('Dragon\'s mother said "No"')
# => Dragon's mother said "No"
```

Если нужно вывести сам обратный слеш, то работает такое же правило. Как и любой другой специальный символ, его надо экранировать:

```python
print("\\")
# => \
```
