
In this lesson, we'll learn what a string is and what role quotation marks play in code.

The definition of a string is quite simple; it's a set of characters. Let us imagine that we have these entries:

```python
'Hello'
'Goodbye'
'G'
' '
''
```

Which of these are strings? In fact, all five of them are:

* С `'Hello'` and `'Goodbye'` everything is obvious, we've already worked with similar constructions and called them strings
* `'G'` and `' '` — are also strings, but they only have one character each
* `''` — is an empty string, so it has zero characters

We consider anything inside quotation marks a string; even if it's just a space, a single character, or no characters at all.

Above we wrote the strings in single quotes, but this is not the only way. You can also use double quotes:

```python
print("Dracarys!")
```

Now imagine you want to type the string _Dragon's mother_. The apostrophe before the letter **s** — is the same symbol as the single quote. Let's print it:

```python
print('Dragon's mother')
# SyntaxError: invalid syntax
```

This program won't work.  From Python's point of view, the line started with a single quote and then ended after the word **dragon**. Next were the characters `s mother` without quotation marks, so it's not a string. And then there was a one line-opening quotation mark that was never closed: ``)`. This code contains a syntax error – you can even tell by the way the code is highlighted.

To avoid this error, we use double quotes. This version of the program will work correctly:

```python
print("Dragon's mother")
```

Now the interpreter knows that the string started with a double quotation mark and must end with a double quotation mark. And the single quote inside has become the part of the string.

It works the other way too. If you want to use double quotes inside a string, you should enclose the string in single quotes. And the number of quotation marks inside the string itself doesn't matter.

Now imagine we want to create this string:

```python
Dragon's mother said "No"
```

It has both single and double quotes. We need to somehow tell the interpreter that the quotation marks are one of the characters inside the string, not the beginning or the end of the string.

The **escape character** is used for this: `\` — a backslash. If we put `\` in front of a quotation mark (single or double), the interpreter will recognize the quotation mark as an ordinary character inside the string, not the beginning or the end of the string:

```python
# We escape the quotation marks around No so that the interpreter
# can recognize them as part of the string
print("Dragon's mother said \"No\"")
# => Dragon's mother said "No"
```

Note that in the example above we didn't have to escape the single quote ('s) because the string itself was created with double quotes. If the string were written in single quotes, the escape character would be used before the apostrophe, not before the double quotes.

If you need to put a backlash in the string, this rule still works. Like any other special character, it must be escaped:

```python
print("\\")
# => \
```
