Мы уже научились писать простые программы, и поэтому можно немного поговорить о том, как писать их правильно.

Код нужно оформлять определенным образом, чтобы он был понятным и простым в поддержке. Существуют специальные наборы правил, которые описывают различные аспекты написания кода — их называют **стандартами кодирования**. В Python стандарт один — [PEP8](https://peps.python.org/pep-0008/). Он отвечает практически на все вопросы о том, как оформлять ту или иную часть кода. Этот документ содержит все правила, которых нужно придерживаться. Новичкам мы советуем завести привычку заглядывать в стандарт PEP8 и писать код по нему.

Сегодня не нужно помнить все правила из стандарта, потому что существуют специальные программы, которые проверяют код автоматически и сообщают о нарушениях. Такие программы называются **линтерами**. Они проверяют код на соответствие стандартам. В Python их достаточно много, и наиболее популярный из них — [flake8](https://flake8.pycqa.org/en/latest/).

Взгляните на пример:

```python
result = 1+ 3
```

Линтер будет ругаться на нарушение правила: *E225 missing whitespace around operator*. По стандарту, оператор `+` всегда должен отделяться пробелами от операндов.

Выше мы увидели правило [E225](https://pep8.readthedocs.io/en/release-1.7.x/intro.html#error-codes) — это одно из большого количества правил. Другие правила описывают отступы, названия, скобки, математические операции, длину строчек и множество иных аспектов. Каждое отдельное правило кажется неважным и мелким, но вместе они составляют основу хорошего кода. Список всех правил flake8 доступен [в этой документации](https://flake8.pycqa.org/en/latest/user/error-codes.html).

Вы уже знакомы с линтером, потому что в практических заданиях платформа Хекслета проверяет ваш код с помощью него. Скоро вы начнете использовать его и за пределами Хекслета, когда будете реализовывать учебные проекты. Вы настроите линтер, и он будет проверять код уже в реальной разработке и сообщать вам о нарушениях.
