We have already learned how to write simple programs, so we can talk a little bit about how to write them correctly.

The code needs to be written in a certain way so that it is understandable and easy to maintain. There are special sets of rules that describe different aspects of writing code - they are called **coding standards**. The standard in Python is one - [PEP8](https://peps.python.org/pep-0008/). It answers practically all the questions about how to design this or that part of the code. This document has all the rules you need to follow. We advise newcomers to get in the habit of looking at the PEP8 standard and writing code according to it.

Today you don't need to remember all the rules from the standard because there are special programs that check the code automatically and report violations. Such programs are called **linters**. They check the code for standards compliance. In Python there are quite a few of them, and the most popular one is — [flake8](https://flake8.pycqa.org/en/latest/).

Take a look at an example:

```python
result = 1+ 3
```

Linter will swear for breaking the rule: _E225 missing whitespace around operator_. By standard, the `+` operator must always be separated by spaces from the operands.

Above we saw the rule [E225](https://www.flake8rules.com/rules/E225.html) — is one of a large number of rules. Other rules describe indents, names, brackets, mathematical operations, line lengths, and a host of other aspects. Each individual rule seems unimportant and shallow, but together they form the basis of good code. A list of all the flake8 rules is available [on a documentation page](https://www.flake8rules.com/).

You are already familiar with the linter because the Hexlet platform uses it to check your code in hands-on assignments. Soon you will start using it outside of Hexlet as well, when you implement training projects. You'll set up the linter, and it will check your code already in real development and tell you about irregularities.
