
В математике существуют разные виды чисел, например, натуральные - это целые числа от одного и больше, или рациональные - это числа с точкой, например 0.5. С точки зрения устройства компьютеров, между этими видами чисел пропасть. Попробуйте ответить на простой вопрос, сколько будет *0.2 + 0.1*? А теперь посмотрим, что на это скажет Python:

```python
0.2 + 0.1 # 0.30000000000000004
```

Операция сложения двух рациональных чисел внезапно привела к неточному вычислению результата. Тот же самый результат выдадут и другие языки программирования. Такое поведение обуславливается ограничениями вычислительных мощностей. Объём памяти, в отличие от чисел, конечен (бесконечное количество чисел требует бесконечного количества памяти для своего хранения).

Рациональные числа не выстроены в непрерывную цепочку, между *0.1* и *0.2* бесконечное множество чисел. Соответственно возникает серьезная проблема, а как хранить рациональные числа? Это интересный вопрос сам по себе. В интернете множество статей, посвященных организации памяти в таких случаях. Более того, существует стандарт, в котором описано, как это делать правильно, и подавляющее число языков на него опирается.

Для нас, как для разработчиков, важно понимать, что операции с плавающими числами неточны (эту точность можно регулировать), а значит при решении задач, связанных с подобными числами, необходимо прибегать к специальным трюкам, которые позволяют добиться необходимой точности.
