
In mathematics there are different kinds of numbers, for example, natural numbers are integers from one and up, or rational numbers are numbers with a point, such as 0.5. From the point of view of computers, there is a chasm between these types of numbers. Try answering the simple question of how much would *0.2 + 0.1*? Now let's see what Python has to say about it:

```python
0.2 + 0.1 # 0.30000000000000004
```

The operation of adding two rational numbers suddenly results in an inaccurate calculation. The same result will be given by other programming languages. Such behavior is due to limitations of computing power. The memory capacity, unlike numbers, is finite (an infinite number of numbers requires an infinite amount of memory to store them).

Rational numbers are not lined up in a continuous chain, between *0.1* и *0.2* an infinite set of numbers. Accordingly, a serious problem arises, but how to store rational numbers? This is an interesting question in itself. There are many articles on the Internet devoted to organizing memory in such cases. Moreover, there is a standard which describes how to do this correctly, and an overwhelming number of languages rely on it.

For us, as developers, it is important to understand that operations with floating numbers are inaccurate (this accuracy can be adjusted), which means that when solving problems involving such numbers, it is necessary to resort to special tricks that allow to achieve the necessary accuracy.
