Let us imagine that we need to calculate such an expression: `2 + 2 * 2`. That's exactly what we'll write down:

```python
print(2 + 2 * 2)  # => 6
```

In school mathematics there is a concept of "operation priority". The priority determines in what order the operations should be performed. Multiplication and division have a higher priority than addition and subtraction, and the priority of exponentiation is higher than all other arithmetic operations. For example: `2 ** 3 * 2` will be calculated in `16`.

But often the calculations must take place in an order different from the standard priority. Then the priority must be set with parentheses. This was also the case at school, for example: `(2 + 2) * 2`. Brackets can be placed around any operation. They can fit into each other as many times as you like. Here are examples:

```python
print(3 ** (4 - 2))  # => 9
print(7 * 3 + (4 / 2) - (8 + (2 - 1)))  # => 14
```

The main thing is to observe pairing - to close brackets in the correct order. This is often the cause of errors not only for beginners, but for experienced programmers as well. For convenience, put the opening and closing parentheses at once, and then write the inner part. The editor on our site (and most other code editors) do this automatically: you write `(`, and the editor immediately adds `)`. This also applies to other paired characters, such as quotation marks. We'll talk about them in future lessons.

Sometimes an expression is hard to perceive visually. Then you can place brackets without affecting the priority:

```python
# Was
print(8 / 2 + 5 - -3 / 2)  # => 10.5

# Became
print(((8 / 2) + 5) - (-3 / 2))  # => 10.5
```

The important thing to remember is that code is written for people. People will read the code and machines will only execute it. For machines the code is correct or incorrect. There is no "more" understandable or "less" understandable code for them.
