
Знак операции, такой как `+`, называют **оператором**. Операторы выполняют операции над определенными значениями, которые называются **операндами**. Сами операторы — это обычно один или несколько символов. Реже — слово. Подавляющее большинство операторов соответствуют математическим операциям.

```python
print(8 + 2)
```

https://replit.com/@hexlet/python-basics-arithmetics-operators

В этом примере `+` — это оператор, а числа `8` и `2` — это **операнды**.

Когда мы складываем, у нас есть два операнда: один слева, другой справа от знака `+`. Операции, которые требуют наличия двух операндов, называются **бинарными**. Если пропустить хотя бы один операнд, например, `3 +`, то программа завершится с синтаксической ошибкой.

Операции бывают не только бинарными, но и унарными — с одним операндом, и тернарными — с тремя операндами. Причем операторы могут выглядеть одинаково, но обозначать разные операции.  Символы `+` и `-` используются не только как операторы. Когда речь идет про отрицательные числа, то знак минуса становится частью числа:

```python
print(-3)  # => -3
```

Выше пример применения унарной операции к числу `3`. Оператор минус перед тройкой говорит интерпретатору взять число `3` и найти противоположное, то есть `-3`. Это может сбить с толку, потому что `-3` — это одновременно и число само по себе, и оператор с операндом. Но у языков программирования такая структура.
