На базовом уровне компьютеры оперируют только числами. Даже в прикладных программах на высокоуровневых языках внутри много чисел и операций над ними. Но для старта достаточно знать обычную арифметику — с нее и начнем.

Например, для сложения двух чисел в математике мы пишем: `3 + 4`. В программировании — то же самое. Вот программа, которая складывает два числа:

```python
3 + 4
```

Арифметика в программировании практически не отличается от школьной арифметики.

Строчка кода `3 + 4` заставит интерпретатор сложить числа и узнать результат. Эта программа будет работать, но в ней нет смысла. По сути, мы не даем команду интерпретатору, мы просто говорим ему: «смотри, сумма трех и четырех». В реальной работе недостаточно сообщать интерпретатору о математическом выражении.

Например, если создавать интернет-магазин, недостаточно просить интерпретатор посчитать стоимость товаров в корзине. Нужно просить посчитать стоимость **И** показать цену покупателю.

Нам нужно попросить интерпретатор сложить `3 + 4` **И** дать команду сделать что-то с результатом. Например, вывести его на экран:

```python
# Сначала вычисляется сумма,
# затем она передается в функцию печати
print(3 + 4)
```

После запуска на экране появится результат:

<pre class='hexlet-basics-output'>
7
</pre>

Кроме сложения доступны следующие операции:

* `-` — вычитание
* `*` — умножение
* `**` — возведение в степень
* `/` — деление
* `//` — [целочисленное деление](https://ru.wikipedia.org/wiki/Деление_с_остатком#В_программировании)
* `%` — [остаток от деления](https://ru.wikipedia.org/wiki/Деление_с_остатком)

Теперь выведем на экран результат деления, а потом результат возведения в степень:

```python
print(8 / 2)   # => 4.0 (При делении двух чисел получается тип данных float)
print(3 ** 2)  # => 9
```

https://replit.com/@hexlet/python-basics-arithmetics-basics

Иногда для удобства мы будем показывать в комментариях результат запуска строчек кода вот так: `=> РЕЗУЛЬТАТ`. Например, `# => 4`.

Первая инструкция выведет на экран `4` (потому что 8 / 2 равно 4), а вторая инструкция выведет на экран 9 (потому что 3<sup>2</sup> равно 9).
