
Наш сайт автоматически проверяет ваши решения. Как это работает?

В самом простом случае система просто запускает ваш код и смотрит на то, что вывелось на экран. А потом сверяет с тем, что мы «ожидали» по заданию.

В следующих, более сложных уроках вы будете писать функции — некие мини-программы, принимающие информацию из внешнего мира и производящие какие-то операции. Проверка ваших решений в таких случаях выглядит немного сложнее: система запускает ваше решение и передаёт какую-то информацию. Система также знает — «ожидает» — какой именно ответ должна дать правильная функция при таких входных данных.

Например, если ваша задача — написать функцию сложения двух чисел, то проверочная система будет передавать ей разные комбинации чисел и сверять ответ вашей функции с реальными суммами. Если во всех случаях ответы совпадут, то решение считается верным.

Такой подход называется тестированием, и он используется в реальной повседневной разработке. Обычно программист сначала пишет тест — проверочную программу, а потом уже ту программу, которую хотел написать. В процессе он постоянно запускает тесты и смотрит, приблизился ли он к решению.

Именно поэтому наш сайт говорит «Тесты пройдены», когда вы правильно решили задачу.

Вот простой пример: в одном из будущих уроков вам нужно будет написать функцию, которая производит вычисления и выдаёт ответ. Допустим, вы допустили небольшую ошибку, и функция выдала неправильное число. Система ответит примерно так:

<pre class='hexlet-basics-output'>AssertionError: '10' != '35'</pre>

Самое главное начинается после двоеточия: «значение "10" не равно ожидаемому значению "35"». То есть правильная функция должна была выдать 35, но текущее решение работает неправильно и выдаёт 10.

Ещё стоит отметить, что если вы видите, что в редакторе уже присутствует какой-то код, а вместе с ним комментарии `BEGIN` и `END`, то обычно это подразумевает, что вам нужно писать ваш код между этими самыми BEGIN и END! Код, данный вам заранее, трогать не стоит: это может повлиять на проверку правильности решения. Проще говоря: видите строчки с комментариями `BEGIN` и `END` — пишите свой код между ними!

---

Иногда в процессе решения будет казаться, что вы сделали все правильно, но система "капризничает" и не принимает решение. Подобное поведение практически исключено. Нерабочие тесты просто не могут попасть на сайт, они автоматически запускаются после каждого изменения. В подавляющем большинстве таких случаев, (а все наши проекты в сумме провели миллионы проверок за много лет), ошибка содержится в коде решения. Она может быть очень незаметной, вместо английской буквы случайно ввели русскую, вместо верхнего регистра использовали нижний или забыли вывести запятую. Другие случаи сложнее. Возможно ваше решение работает для одного набора входных данных, но не работает для другого. Поэтому всегда внимательно читайте условие задачи и вывод тестов. Там почти наверняка есть указание на ошибку.

Однако, если вы уверены в ошибке или нашли какую-то неточность, то вы всегда можете указать на нее. В конце каждой теории есть ссылка на содержимое урока на гитхабе (этот проект полностью открытый!). Перейдя туда, вы можете написать issue, посмотреть содержимое тестов (там видно, как вызывается ваш код) и даже отправить pullrequest. Если для вас это пока темный лес, то подключитесь в наше [сообщество в Telegram](https://t.me/hexletcommunity/3), там в канале *'Обратная связь'* мы всегда поможем.
