Когда мы готовим блюдо, то четко следуем рецепту. Иначе еда окажется не такой, как ожидали. Это же правило действует и в программировании.

Чтобы увидеть на экране ожидаемый результат, нужно дать компьютеру четкие и пошаговые указания. Это можно сделать с помощью инструкций. Инструкция — это команда для компьютера, единица выполнения. Код на Python в этом случае — это набор инструкций. Его можно представить в виде пошагового рецепта.

Код на Python запускает **интерпретатор** — программу, которая выполняет инструкции строго по очереди. Как и шаги в рецепте, набор инструкций для интерпретатора пишутся по порядку и отделяются друг от друга переходом на следующую строку.

Разработчики должны понимать порядок действий в коде и уметь мысленно разделять программу на независимые части, удобные для анализа.

Посмотрим на пример кода с двумя инструкциями. При его запуске на экран последовательно выводятся два предложения:

```python
print('Mother of Dragons.')
print('Dracarys!')
# => Mother of Dragons.
# => Dracarys!
```

https://replit.com/@hexlet/python-basics-instructions

Выше мы говорили, что инструкции отделяются друг от друга переходом на новую строку. Но есть и другой способ: их можно разделить точкой с запятой — `;`:

```python
print('Mother of Dragons.'); print('Drakarys!')
```

Технической разницы между первым и вторым вариантом нет — интерпретатор поймет инструкции одинаково. Разница только в том, что человеку будет неудобно читать второй вариант.

Лучше инструкции располагать друг под другом. Так коллегам будет удобнее читать ваш код, обслуживать его и вносить изменения.
