When we're making a dish, we follow the recipe carefully. Otherwise, the food won't turn out as expected. The same rule applies to programming.

If you want to see the expected result onscreen, the computer needs to have clear, step-by-step directions. This can be done using instructions. An instruction is a command to the computer, a unit of execution. Python code in this case is a set of instructions. It can be presented as a step-by-step recipe.

Python code is run by an **interpreter**, a program that executes instructions strictly, line by line. Like the steps in a recipe, the instructions for the interpreter are written in order and are separated from each other by skipping to the next line.

Developers must understand the order of operations in the code, and be able to mentally divide the program into independent parts that are convenient for analysis.

  Let's look at an example of some code with two instructions. When it's started, two sentences are displayed sequentially on the screen:

```python
print('Mother of Dragons.')
print('Dracarys!')
# => Mother of Dragons.
# => Dracarys!
```

We said above that instructions are separated from each other by a line break. But there is another way; they can be separated by a semicolon — `;`:

```python
print('Mother of Dragons.'); print('Drakarys!')
```

  There is no technical difference between the first and second version; the interpreter will understand the instructions the same way. The only difference is that it's inconvenient, physically, to read the second version.

It's better to place the instructions under each other. This makes it easier for colleagues to read your code, maintain it, and make changes.
