# <img src="https://raw.githubusercontent.com/hewiefreeman/GopherClientJS/master/JS_Gopher.png" width="180" height="180"> Gopher Game Server - Javascript Client

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0) [![GoDoc](https://godoc.org/github.com/hewiefreeman/GopherGameServer?status.svg)](https://godoc.org/github.com/hewiefreeman/GopherGameServer) <img src="https://img.shields.io/badge/version-v1.0--beta.1-blue.svg">

This is the JavaScript client API for [Gopher Game Server](https://github.com/hewiefreeman/GopherGameServer). It provides all the functionalities to use Gopher Game Server with vanilla, or any JavaScript libraries. Source files can be found in the `src` folder, examples in the `example` folder, and minified source files in the `src/min` folder.

# :books: Usage

## Table of Contents

1) [**Getting Started**](https://github.com/hewiefreeman/GopherClientJS/wiki/Getting-Started)
   - [Set-Up](https://github.com/hewiefreeman/GopherClientJS/wiki/Getting-Started#set-up)
   - [Connecting to the Server](https://github.com/hewiefreeman/GopherClientJS/wiki/Getting-Started#connecting-to-the-server)
2) [**Client Actions**](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions)
   - [Login & Logout](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions#login--logout)
   - [Rooms](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions#rooms)
   - [User Variables](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions#user-variables)
   - [Messaging](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions#messaging)
   - [Executing Custom Client Actions](https://github.com/hewiefreeman/GopherClientJS/wiki/Client-Actions#executing-custom-client-actions)
3) [**SQL Authentication**](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication)
   - [Creating accounts](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#creating-accounts)
   - [Deleting Accounts](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#deleting-accounts)
   - [Login](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#login)
   - [Changing Passwords](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#changing-passwords)
   - [Changing Custom Account Info](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#changing-custom-account-info)
   - [Auto-Login (Remember Me)](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#auto-login-remember-me)
   - [Friending](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#friending)
   - [User Status](https://github.com/hewiefreeman/GopherClientJS/wiki/SQL-Authentication#user-status)

# :milky_way: Contributions
Contributions are open and welcomed! Help is needed for everything from documentation, cleaning up code, performance enhancements, client APIs (in any laguage) and more. Don't forget to show your support by starring or following the project!

If you want to make a client API in an unsupported language and want to know where to start and/or have any questions, feel free to [email me](mailto:dominiquedebergue@gmail.com?subject=[GitHub]%20Gopher%20Game%20Server)!

Please read the following articles before submitting any contributions or filing an Issue:

 - [Contribution Guidlines](https://github.com/hewiefreeman/GopherGameServer/blob/master/CONTRIBUTING.md)
 - [Code of Conduct](https://github.com/hewiefreeman/GopherGameServer/blob/master/CODE_OF_CONDUCT.md)
