/*
* Copyright (C) 2020 HERE Europe B.V.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* SPDX-License-Identifier: Apache-2.0
* License-Filename: LICENSE
*/

import heresdk
import UIKit

public class VenueTableViewCell: UITableViewCell {
    @IBOutlet private weak var label: UILabel!
    private var venue: Venue?
    private var venueMap: VenueMap?

    public func setup(_ map: VenueMap?, venue: Venue?) {
        venueMap = map
        self.venue = venue
        if let venueModel = venue?.venueModel {
            label.adjustsFontSizeToFitWidth = true
            label.text = String(venueModel.id) + ": " + (venueModel.properties["name"]?.string ?? "")
        }
    }

    @IBAction private func onRemoveButtonTap(_ sender: Any) {
        if let venue = venue, let venueMap = venueMap {
            venueMap.removeVenue(venue: venue)
        }
    }
}
