# Map Objects 

## Prerequisites

Update manifest file with proper license key as described above in root [README file](../README.md).

## Purpose

Gives a simple example of Map Objects and how to work with them.

You can find more details regarding available map objects in [Map Objects and Interactions](https://developer.here.com/documentation/android-premium/dev_guide/topics/map-objects-and-interaction.html) and [Marker Clustering](https://developer.here.com/documentation/android-premium/dev_guide/topics/marker-clustering.html) sections.

## Example

Code snippet which builds few predefined map objects on map: 
- MapPolygon
- MapPolyline
- MapCircle
- MapMarker

## References
- [Map Documentation](https://developer.here.com/documentation/android-premium/dev_guide/topics/maps.html) - Map Customization and Rendering documentation entry point
- [Map Clustering](https://developer.here.com/documentation/android-premium/dev_guide/topics/marker-clustering.html)
- Other map samples: [Map Attributes](../map-attributes/), [Map Customization](../map-customization/), [Map Downloader](../map-downloader/), [Map Gestures](../map-gestures/), [Map Rendering](../map-rendering/)
