---
linkTitle: Configuration
title: How to configure LinGoose to use APIs
description: How to configure LinGoose to use APIs
menu: main
weight: -5
---

LinGoose implements various APIs to enable you to build AI/LLM applications. For each implementation you need to configure the related API key in your environment.

## OpenAI
You need to set the `OPENAI_API_KEY` environment variable to your OpenAI API key. To get your API key refer to the [OpenAI website](https://openai.com/).

## Cohere
You need to set the `COHERE_API_KEY` environment variable to your Cohere API key. To get your API key refer to the [Cohere website](https://cohere.com/).

## Hugging Face
You need to set the `HUGGING_FACE_HUB_TOKEN` environment variable to your Hugging Face API key. To get your API key refer to the [Hugging Face website](https://huggingface.co/).

## Nomic
You need to set the `NOMIC_API_KEY` environment variable to your Nomic API key. To get your API key refer to the [Nomic website](https://nomic.ai/).


## Anthropic
You need to set the `ANTHROPIC_API_KEY` environment variable to your Anthropic API key. To get your API key refer to the [Anthropic website](https://anthropic.com/).

## Voyage AI
You need to set the `VOYAGE_API_KEY` environment variable to your Voyage AI API key. To get your API key refer to the [Voyage AI website](https://www.voyageai.com/).

## Groq
You need to set the `GROQ_API_KEY` environment variable to your Groq API key. To get your API key refer to the [Groq website](https://groq.com/).