# Pull Request Template

⚠️ **Please do not submit a Pull Request without creating an issue first. Any change needs to be discussed.**

## Description

Please include a summary of the change and which issue is fixed. Please also include relevant motivation and context. List any dependencies that are required for this change.

Fixes # (issue)

## Type of change

Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

## How Has This Been Tested?

Please describe the tests that you ran to verify your changes. Provide instructions so we can reproduce. Please also list any relevant details for your test configuration

- [ ] Test A
- [ ] Test B

## Checklist:

- [ ] I have read the [Contributing documentation](https://github.com/henomis/lingoose/blob/main/CONTRIBUTING.md).
- [ ] I have read the [Code of conduct documentation](https://github.com/henomis/lingoose/blob/main/CODE_OF_CONDUCT.md).
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] I have checked my code and corrected any misspellings

## Policy on Unattended Pull Requests

As part of our commitment to maintaining an active and collaborative development environment, it's important for pull requests (PRs) to receive timely attention and feedback. PRs left unattended for an extended period can impede progress and create bottlenecks in the development process.

Therefore, if a PR remains unapproved and unmodified following a review for an extended period, the author of the PR reserves the right to implement the suggested modifications at their discretion.

The specific duration of time before this policy is enacted may vary depending on the circumstances and urgency of the changes. However, as a general guideline, a reasonable timeframe for review and action might be 2 weeks.

This policy aims to ensure the continued progress of the project while respecting the contributions and efforts of all team members. It encourages timely collaboration and feedback while preventing PRs from stagnating indefinitely.

If you anticipate being unable to review or address a PR within the specified timeframe, please communicate this with the team to avoid invoking this policy unnecessarily.
