// --== CS400 File Header Information ==--
// Name: 				Eric Choi
// Email: 				hchoi256@wisc.edu
// Team: 				ID
// TA:		 			Mu Cai
// Lecturer: 			Gary Dahl
// Notes to Grader: 	<optional extra notes>

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.PriorityQueue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Scoreboard {

  /**
   * An inner class that represents a user with score
   * @author Haining Qiu
   *
   */
  public static class User implements Comparable<User>{
    String name; // username
    long score; // user's score

    /**
     * Creates a new instance of User with username and user's score
     * 
     * @param name  username
     * @param score user's score
     */
    public User(String name, long score) {
      this.name = name;
      this.score = score;
    }

    /**
     * @return username
     */
    public String getName() {
      return name;
    }

    /**
     * @return user's score
     */
    public long getScore() {
      return score;
    }
    
    /**
     * Increments the score of this user by one when the user get a test correct.
     */
    public void incScore() {
      score += 1;
    }

    /**
     * Compares this User with another User o by comparing the score.
     * 
     * @param o another User
     */
    @Override
    public int compareTo(User o) {
      return Long.compare(o.getScore(), this.getScore());
    }
  }
  
  private static PriorityQueue<User> users = new PriorityQueue<User>(10); // Used for highest-score board
  private final static String FILE_NAME = "scoreboard.json"; // A JSON file that stores users' score
//  private static HashTableMap<String, Integer> answers;

  /**
   * Loads all stored users' scores into the priority queue.
   * 
   * @return true if load successfully, false otherwisely
   */
  @SuppressWarnings("unchecked")
  public static boolean loadUserFromJSON() {
    JSONParser parser = new JSONParser();
    try (FileReader reader = new FileReader(FILE_NAME)) { // Read JSON file
      Object arr = parser.parse(reader); // Parser JSON file
      JSONArray userScore = (JSONArray) arr;
      userScore.forEach( user -> addUser((JSONObject) user) ); // Load all users in the file
      reader.close();
      return true;
    } catch (FileNotFoundException e) {
      e.printStackTrace();
      return false;
    } catch (IOException e) {
      e.printStackTrace();
      return false;
    } catch (ParseException e) {
      e.printStackTrace();
      return false;
    }
  }
  
  /**
   * Adds a user to the priority queue. Notice that this is a private helper method interfacing with
   * data level, NOT front end level. Do not make call to this method.
   * 
   * @param user a JSONObject in the JSONArray
   */
  private static void addUser(JSONObject user) {
    users.add(new User((String)user.get("username"), (long)user.get("score")));
  }
  
  /**
   * Writes all users with their scores into the JSON file.
   */
  @SuppressWarnings("unchecked")
  public static void storeUserIntoJSON() {
    JSONArray arr = new JSONArray();
    users.forEach( user -> { // Convert every element into a JSONObject and add it to the JSONArray
      JSONObject obj = new JSONObject();
      obj.put("username", user.getName());
      obj.put("score", user.getScore());
      arr.add(obj);
    } );
    // Write the JSONArray to the JSON file
    try (FileWriter writer = new FileWriter(FILE_NAME)) {
      writer.write(arr.toJSONString());
      writer.flush();
      writer.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  
//  /**
//   * Adds a new user to the priority queue. This method should be called when there is a new user
//   * starting a test.
//   * 
//   * @param username username of the new user
//   * @param score    0
//   */
//  public static void newUser(String username, long score) {
//    users.add(new User(username, score));
//  }
  
//  /**
//   * Loads a hash table that contains the correct answer pairs provided by the data wrangler
//   * 
//   * @param answers
//   */
//  public void loadAnswers(HashTableMap<String, Integer> answers) {
//    this.answers = answers;
//  }
  
  /**
   * Builds a string representation of the score board, which shows the highest ten scores.
   * 
   * @return a string representation of the score board
   */
  private static String displayScoreboard() {
    String board = "<table><tr>\n<th>Username</th>\n<th>Score</th>\n</tr>\n";
    User highest;
    for (int i = 0; i < 10; ++i) {
      highest = users.remove();
      board += "<tr>\n";
      board += "<td>" + highest.getName() + "</td>\n";
      board += "<td>" + highest.getScore() + "</td>\n";
      board += "</tr>\n";
    }
    board += "</table>\n";
    return board;
  }
  
  private static void printHTML() {
    System.out.println("<html><head>");
    System.out.println("<title>Scoreboard</title>\r\n" + "    <meta charset=\"UTF-8\"/>\r\n"
        + "    <meta name=\"Author\" content=\"Haining Qiu\"/>");
    System.out.println("<style>");
    System.out.println("table {");
    System.out.println("    border-collapse: collapse;");
    System.out.println("    margin: 40px 30px;");
    System.out.println("    font-size: 1em;");
    System.out.println("    font-family: sans-serif;");
    System.out.println("    min-width: 400px;");
    System.out.println("    box-shadow: 0 0 20px #00000040;");
    System.out.println("}");
    System.out.println("th, td {");
    System.out.println("    padding: 12px 15px;");
    System.out.println("}");
    System.out.println("tr {");
    System.out.println("    border-bottom: 1px solid #dddddd;");
    System.out.println("}");
    System.out.println("tr:nth-of-type(even) {");
    System.out.println("    background-color: #f3f3f3;");
    System.out.println("}");
    System.out.println("tr:last-of-type {");
    System.out.println("    border-bottom: none;");
    System.out.println("}");
    System.out.println("</style></head><body>");
    System.out.println(displayScoreboard());
    System.out.println("</body></html>");
  }

  public static void main(String[] args) {
    String[] query = args[0].split("&");
    String[] username = query[0].split("=");
    String[] score = query[1].split("=");
    User newUser = new User(username[1], Long.parseLong(score[1]));
    loadUserFromJSON();
    users.add(newUser);
    storeUserIntoJSON();
    printHTML();
  }
}
