// --== CS400 File Header Information ==--
// Name:                Eric Choi
// Email:               hchoi256@wisc.edu
// Team:                ID
// TA:                  Mu Cai
// Lecturer:            Gary
// Notes to Grader:     <optional extra notes>

import static org.junit.Assert.fail;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
/**
 * This class implements junit tests to test if public methods in Backend.java
 * works as expected
 * 
 * @author Boshan Chen
 * @author Eric Choi
 *
 */
public class TestSuite { 
    @BeforeEach
	public void init() {
		try {
			FileWriter fileW = new FileWriter("test.json");
			fileW.write("[]");
			fileW.flush();
			fileW.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Case 1: adding one element to empty json file
	 */
	@Test
	public void testSendTC_1() {
		Backend b = new Backend();
		init();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.sendTC(1, "Toyota");
		if (!b.Contains(1))
			fail();

		recoverTest();
	}

	/**
	 * Case 2: add duplicate values to empty file
	 */
	@Test
	public void testSendTC_2() {
		Backend b = new Backend();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.sendTC(1, "Toyota");
		b.sendTC(3, "Volvo");

		if (!b.Contains(1) || !b.sendTC(2, "Toyota") || !b.Contains(3))
			fail();

		recoverTest();
	}

	/**
	 * Case 2.2: adding duplicate key to empty file
	 */
	@Test
	public void testSendTC_3() {
		Backend b = new Backend();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.sendTC(1, "Apple");
		b.sendTC(2, "Toyota");
		boolean check = b.sendTC(2, "Volvo");
		b.sendTC(4, "BMW");
		b.sendTC(-1, "SuperCell");
		b.sendTC(6, "Blizzard");

		if (!b.Contains(1) || check || !b.Contains(2) || !b.Contains(4) || !b.Contains(-1) || !b.Contains(6))
			fail();

		recoverTest();
	}

	/**
	 * Case 1: remove one element from file
	 */
	@Test
	public void testRemove_1() {
		Backend b = new Backend();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.sendTC(1, "Apple");
		b.sendTC(2, "Apple");
		b.sendTC(3, "Volvo");
		b.sendTC(4, "BMW");
		b.sendTC(-1, "SuperCell");
		b.sendTC(6, "Blizzard");

		if (!b.Contains(1) || !b.Contains(2) || !b.Contains(3) || !b.Contains(4) || !b.Contains(-1) || !b.Contains(6)
				|| b.remove(2) != 1)
			fail();

		recoverTest();
	}

	/**
	 * Case 2: remove a non-existed element from file
	 */
	@Test
	public void testRemove_2() {
		Backend b = new Backend();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.sendTC(1, "Apple");
		b.sendTC(2, "Apple");
		b.sendTC(3, "Volvo");
		b.sendTC(4, "BMW");
		b.sendTC(5, "SuperCell");
		b.sendTC(6, "Blizzard");

		if (!b.Contains(1) || !b.Contains(2) || !b.Contains(3) || !b.Contains(4) || !b.Contains(6) || b.remove(0) != 0
				|| b.remove(-1) != 0)
			fail();

		recoverTest();

	}

	/**
	 * case 3: remove elements from empty file
	 */
	@Test
	public void testRemove_3() {
		Backend b = new Backend();
		HashTableMap test = b.getTestCases();

		if (test == null)
			fail();
		if (test.size() != 0)
			fail();

		b.remove(0);
		b.sendTC(1, "Apple");
		b.sendTC(2, "Apple");
		b.sendTC(3, "Volvo");
		b.sendTC(4, "BMW");
		b.sendTC(5, "SuperCell");
		b.sendTC(6, "Blizzard");
		b.remove(0);
		test = b.getTestCases();
		if (test.size() != 6)
			fail();

		for (int i = 0; i < test.size(); ++i) {
			if (test.getList()[i] != null) {
				if (!test.getList()[i].element().getValue().equals(test.getList()[i].element().getValue()))
					fail();
				if (!test.getList()[i].element().getKey().equals(test.getList()[i].element().getKey()))
					fail();
			}
		}
		recoverTest();

	}

	/**
	 * Recover the test.json file after finishing the tests.
	 */
	@AfterEach
	private void recoverTest() {
		init();
		Backend b = new Backend();
		b.sendTC(1, "Samsung");
		b.sendTC(2, "Apple");
		b.sendTC(3, "Huawei");
		b.sendTC(4, "Xiaomi");
		b.sendTC(5, "Nokia");
		b.sendTC(6, "Sony");
		b.sendTC(7, "HTC");
		b.sendTC(8, "Motoral");
		b.sendTC(9, "Lenovo");
		b.sendTC(10, "Oneplus");
		b.sendTC(11, "Chevrolet");
		b.sendTC(12, "Volkswagen");
		b.sendTC(13, "Toyota");
		b.sendTC(14, "Kia");
		b.sendTC(15, "Hyundai");
		b.sendTC(16, "Toyota");
		b.sendTC(17, "Honda");
		b.sendTC(18, "Mazda");
		b.sendTC(19, "Lamborghini");
		b.sendTC(20, "Porsche");
		b.sendTC(21, "experience");
		b.sendTC(22, "experiment");
		b.sendTC(23, "desert");
		b.sendTC(24, "dessert");
		b.sendTC(25, "lose");
		b.sendTC(26, "loose");
		b.sendTC(27, "principal");
		b.sendTC(28, "principle");
		b.sendTC(29, "sensitive");
		b.sendTC(30, "sensible");
	}
}
