import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

// --== CS400 File Header Information ==--
// Name: 				Eric Choi
// Email: 				hchoi256@wisc.edu
// Team: 				ID
// TA:		 			Mu Cai
// Lecturer: 			Gary Dahl
// Notes to Grader: 	<optional extra notes>

public class Backend {
	private final static String fileDir_test = "test.json"; // test cases

	/**
	 * This constructor involves some process that is necessary to be called for
	 * this application up and running
	 */
	public Backend() {
		Init_JSON();
	}

	/**
	 * Initialize JSON files
	 */
	private void Init_JSON() {
		Init_t();
	}

	/**
	 * initialize this JSON file for test resources so that it will operate under
	 * our rules
	 */
	private boolean Init_t() {
		File file = new File(fileDir_test);
		if (!file.exists()) {
			return false;
		}
		try {
			FileReader fileR = new FileReader(fileDir_test);
			if (fileR.read() != (int) '[') {
				fileR.close();

				FileWriter fileW = new FileWriter(fileDir_test);
				fileW.write("[]");
				fileW.flush();
				fileW.close();

				return true;
			}
			fileR.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * This method is made to copy the JSON content into the given file data2.json
	 * 
	 * @param jsonArr jsonArray object
	 */
	private boolean writeJSON_html(String fileDir, JSONArray jsonArr) {
		try {
			String identifier = "Test = ";

			FileWriter file = new FileWriter(fileDir);
			file.write(identifier + jsonArr.toJSONString());
			file.flush();
			file.close();

			return true;
		} catch (IOException e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * This method is made to copy the JSON content into the given file data.json
	 * 
	 * @param fileName
	 * @param jsonArr  jsonArray object
	 */
	private boolean writeJSON(String fileName, JSONArray jsonArr) {
		try {
			FileWriter file = new FileWriter(fileName);
			file.write(jsonArr.toJSONString());
			file.flush();
			file.close();

			writeJSON_html(fileName.split(".json")[0].toString() + "c" + ".json", jsonArr);

			return true;
		} catch (IOException e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * This method is made to add new data into the given file
	 * 
	 * @param fileName
	 * @param jsonObj
	 */
	@SuppressWarnings({ "unchecked" })
	private boolean add(String fileName, JSONObject jsonObj) {
		JSONParser parser = new JSONParser();
		try {
			Object obj = parser.parse(new FileReader(fileName));
			JSONArray json_arr = (JSONArray) obj;

			for (int k = 0; k < json_arr.size(); k++) {
				JSONObject tempJson = (JSONObject) json_arr.get(k);
				if (tempJson.get("key").equals(jsonObj.get("key"))) {
					System.out.println("Already Exist!");
					return false;
				}
			}

			json_arr.add(jsonObj);

			return writeJSON(fileName, json_arr);
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * This method helps the process of removing unwanted data from this file
	 * 
	 * @param jArr javaArray object
	 * @param key
	 */
	private JSONArray RemoveJSON(JSONArray jArr, long key) {
		try {
			JSONArray json_arr = (JSONArray) jArr;

			for (int i = 0; i < json_arr.size(); i++) {
				JSONObject jObj_main = (JSONObject) json_arr.get(i);

				if (key == (long) jObj_main.get("key")) {
					json_arr.remove(i);

					return json_arr;
				}
			}

			return null;
		} catch (Exception e) {
			e.printStackTrace();

			return null;
		}
	}

	/**
	 * This method is made to remove unwanted data from this file
	 * 
	 * @param long key
	 * 
	 * @return 1: success, 0: No data found, -1: Error
	 */
	public Integer remove(long key) {
		String fileName = fileDir_test;

		JSONParser parser = new JSONParser();
		try {
			Object obj = parser.parse(new FileReader(fileName));
			JSONArray json_arr = (JSONArray) obj;

			json_arr = RemoveJSON(json_arr, key); // Remove data that exist at an index from
													// the global variable

			if (json_arr != null) {
				if (writeJSON(fileName, json_arr)) {
					System.out.println("Deletion Complete!");
					return 1;
				}
			}

			System.out.println("No such data found");
			return 0;
		} catch (Exception e) {
			e.printStackTrace();

			return -1;
		}
	}

	/**
	 * This method helps the process of loading the content of this file
	 * 
	 * @param jArr JSONArray to the content of this file
	 */
	private HashTableMap loadJSON(JSONArray jArr) {
		HashTableMap res = new HashTableMap();
		try {
			JSONArray json_arr = (JSONArray) jArr;

			for (int i = 0; i < json_arr.size(); i++) {
				JSONObject jObj_main = (JSONObject) json_arr.get(i);

				res.put((long) jObj_main.get("key"), (String) jObj_main.get("value"));
			}

			return res;
		} catch (Exception e) {
			e.printStackTrace();

			return null;
		}
	}

	/**
	 * This method is made to load the content of this file
	 * 
	 * @param fileName
	 */
	private HashTableMap load(String fileName) {
		JSONParser parser = new JSONParser();
		try {
			Object obj = parser.parse(new FileReader(fileName));
			JSONArray json_arr = (JSONArray) obj;

			return loadJSON(json_arr);
		} catch (Exception e) {
			e.printStackTrace();

			return null;
		}
	}

	// send a test case
	@SuppressWarnings("unchecked")
	public boolean sendTC(long key, String value) {
		if (value == null || value == "") {
			System.out.println("Wrong  Value");
			return false;
		}

		JSONObject obj = new JSONObject();
		obj.put("value", value);
		obj.put("key", key);

		return add(fileDir_test, obj);
	}

	// load the data of user test results
	public HashTableMap getTestCases() {
		return load(fileDir_test);
	}
	
	// contains
	public boolean Contains(long key) {
		HashTableMap hashT = getTestCases();
		return hashT.containsKey(key);
	}
}
