[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/hb20007/hands-on-nltk-tutorial/master)

# Hands-On NLTK Tutorial

> The hands-on NLTK tutorial in the form of Jupyter notebooks

NLTK is one of the most popular Python packages for Natural Language Processing (NLP).

## Index of Jupyter Notebooks

|Notebooks|
|---|
|[1.1 Downloading Libs and Testing That They Are Working](1-1-Downloading-Libs-and-Testing-That-They-Are-Working.ipynb)<br>*Getting ready to start!*|
|[1.2 Text Analysis Using nltk.text](1-2-Text-Analysis-Using-nltk.text.ipynb)<br>*Extracting interesting data from a given text*|
|[2.1 Deriving N-Grams from Text](2-1-Deriving-N-Grams-from-Text.ipynb)<br>*Creating n-grams (for language classification)*|
|[2.2 Detecting Text Language by Counting Stop Words.ipynb](2-2-Detecting-Text-Language-by-Counting-Stop-Words.ipynb)<br>*A simple way to find out what language a text is written in*|
|[2.3 Language Identifier Using Word Bigrams](2-3-Language-Identifier-Using-Word-Bigrams.ipynb)<br>*State-of-the-art language classifier*|
|[3.1 Bigrams, Stemming and Lemmatizing](3-1-Bigrams-Stemming-and-Lemmatizing.ipynb)<br>*NLTK makes bigrams, stemming and lemmatization super-easy*|
|[3.2 Finding Unusual Words in Given Language](3-2-Finding-Unusual-Words-in-Given-Language.ipynb)<br>*Which words do not belong with the rest of the text?*|
|[3.3 Creating a POS Tagger](3-3-Creating-a-POS-Tagger.ipynb)<br>*Creating a Parts Of Speech tagger*|
|[3.4 Parts of Speech and Meaning](3-4-Parts-of-Speech-and-Meaning.ipynb)<br>*Exploring awesome features offered by WordNet*|
|[4.1 Name Gender Identifier](4-1-Name-Gender-Identifier.ipynb)<br>*Building a classifier that guesses the gender of a name*|
|[4.2 Classifying News Documents into Categories](4-2-Classifying-News-Documents-into-Categories.ipynb)<br>*Building a classifier that guesses the category of a news item*|
|[5.1 Sentiment Analysis](5-1-Sentiment-Analysis.ipynb)<br>*Is a movie review positive or negative?*|
|[5.2 Sentiment Analysis with nltk.sentiment.SentimentAnalyzer and VADER tools](5-2-Sentiment-Analysis-with-nltk.sentiment.SentimentAnalyzer-and-VADER-tools.ipynb)<br>*More sentiment analysis!*|
|[6.1 Twitter Stream (and Cleaning Tweets)](6-1-Twitter-Stream-and-Cleaning-Tweets.ipynb)<br>*Live-stream tweets from Twitter*|
|[6.2 Twitter Search](6-2-Twitter-Search.ipynb)<br>*Search through past tweets*|
|[7.1 NLTK with the Greek Script](7-1-NLTK-with-the-Greek-Script.ipynb)<br>*Using NLTK with foreign scripts*|
|[8.1 The langdetect and langid Libraries](8-1-The-langdetect-and-langid-Libraries.ipynb)<br>*Useful libraries for language identification*|
|[8.2 Word2Vec (gensim)](8-2-Word2vec-(gensim).ipynb)<br>*Google's Word2vec*|

## Meta

H. Z. Sababa — hb20007 — <hzsababa@outlook.com>

Distributed under the MIT license. See [`LICENSE`](LICENSE) for more information.
