import {
  BookIcon,
  DatabaseIcon,
  GlobeIcon,
  LaptopIcon,
  MailIcon,
  ServerIcon,
} from 'lucide-react';
import Image from 'next/image';
import { twMerge } from 'tailwind-merge';
import ApiImage from './api.png';
import AppImage from './app.png';
import DocsImage from './docs.png';
import EmailImage from './email.png';
import StudioImage from './studio.png';
import WebImage from './web.png';

const apps = [
  {
    icon: LaptopIcon,
    name: 'app',
    title: 'Lightning-fast app template',
    description:
      "Start building your app with a shadcn/ui template that's already set up with everything you need — Tailwind, Clerk and more.",
    image: AppImage,
  },
  {
    icon: ServerIcon,
    name: 'api',
    title: 'Cross-platform API',
    description:
      'Create an API microservice for many different apps, with a type-safe database ORM and webhook handlers.',
    image: ApiImage,
  },
  {
    icon: MailIcon,
    name: 'email',
    title: 'React-based email templates',
    description:
      'Create and preview email templates with a React-based email library, then send them with a simple API powered by Resend.',
    image: EmailImage,
  },
  {
    icon: GlobeIcon,
    name: 'web',
    title: 'Robust, type-safe website',
    description:
      'A twblocks website template with a type-safe blog, bulletproof SEO and legal pages, powered by BaseHub.',
    image: WebImage,
  },
  {
    icon: BookIcon,
    name: 'docs',
    title: 'Powered by Mintlify',
    description:
      'Simple, beautiful out of the box and easy to maintain documentation. Pages are automatically generated from your markdown files.',
    image: DocsImage,
  },
  {
    icon: DatabaseIcon,
    name: 'studio',
    title: 'Visual database editor',
    description:
      'Use Prisma to generate a type-safe client for your database, and Prisma Studio to visualize and edit it.',
    image: StudioImage,
  },
];

const App = ({ app, index }: { app: (typeof apps)[number]; index: number }) => (
  <div className="relative flex flex-col gap-8 overflow-hidden p-8 pb-0">
    <div className="flex flex-col gap-4">
      <div className="flex items-center gap-2 text-neutral-500">
        <app.icon size={14} />
        <small>/apps/{app.name}</small>
      </div>
      <div className="flex flex-col gap-2">
        <h2 className="font-bold text-2xl tracking-tight sm:truncate">
          {app.title}
        </h2>
        <p className="text-neutral-600 sm:line-clamp-2">{app.description}</p>
      </div>
    </div>
    <div className="h-48 overflow-hidden bg-neutral-50 md:h-80 dark:bg-neutral-950">
      <Image
        alt=""
        src={app.image}
        className={twMerge(
          'h-auto w-full overflow-hidden rounded-md border object-cover object-left shadow-sm',
          [0, 3, 4].includes(index) ? '' : 'md:h-[120%] md:w-auto md:max-w-none'
        )}
      />
    </div>
  </div>
);

export const Apps = () => (
  <section className="grid sm:grid-cols-2" id="apps">
    {apps.map((app, index) => (
      <div
        className={twMerge(
          index % 2 && 'sm:border-l',
          index > 0 && 'border-t sm:border-t-0',
          index > 1 && '!border-t'
        )}
        key={index}
      >
        <App app={app} index={index} />
      </div>
    ))}
  </section>
);
