# Software design patterns

https://en.wikipedia.org/wiki/Software_design_pattern

## Creational

- [ ] Abstract factory
- [ ] Builder
- [ ] Dependency Injection
- [ ] Factory method
- [ ] Lazy initialization
- [ ] Multiton
- [ ] Object pool
- [ ] Resource acquisition is initialization
- [ ] Singleton

## Structural

- [ ] Adapter, Wrapper, or Translator
- [ ] Bridge
- [ ] Composite
- [ ] Decorator
- [ ] Extension object
- [ ] Facade
- [ ] Flyweight
- [ ] Front controller
- [ ] Marker
- [ ] Module
- [ ] Proxy
- [ ] Twin

## Behavioural

- [ ] Blackboard
- [ ] Chain of responsibility
- [ ] Command
- [ ] Interpreter
- [ ] Iterator
- [ ] Mediator
- [ ] Memento
- [ ] Null object
- [ ] Observer or Publish/subscribe
- [ ] Servant
- [ ] Specification
- [ ] State
- [ ] Strategy
- [ ] Template method
- [ ] Visitor

## Concurrency

- [ ] Active Object
- [ ] Balking
- [ ] Binding properties
- [ ] Compute kernel
- [ ] Double-checked locking
- [ ] Event-based asynchronous
- [ ] Guarded suspension
- [ ] Join
- [ ] Lock
- [ ] Messaging design pattern (MDP)
- [ ] Monitor object
- [ ] Reactor
- [ ] Read-write lock
- [ ] Scheduler
- [ ] Thread pool
- [ ] Thread-specific storage
