// HARFANG(R) Copyright (C) 2021 Emmanuel Julien, NWNC HARFANG. Released under GPL/LGPL/Commercial Licence, see licence.txt for details.

#include "foundation/country.h"

namespace hg {

static const LocaleInfo countries[] = {
	{"Asia", "South Asia", "Afghanistan", "AF", "AF", "AFG", 4, "AF"},
	{"Europe", "South East Europe", "Albania", "AL", "AL", "ALB", 8, "AL"},
	{"Africa", "Northern Africa", "Algeria", "AG", "DZ", "DZA", 12, "DZ"},
	{"Oceania", "Pacific", "American Samoa", "AQ", "AS", "ASM", 16, "AS"},
	{"Europe", "South West Europe", "Andorra", "AN", "AD", "AND", 20, "AD"},
	{"Africa", "Southern Africa", "Angola", "AO", "AO", "AGO", 24, "AO"},
	{"Americas", "West Indies", "Anguilla", "AV", "AI", "AIA", 660, "AI"},
	{"Americas", "West Indies", "Antigua and Barbuda", "AC", "AG", "ATG", 28, "AG"},
	{"Americas", "South America", "Argentina", "AR", "AR", "ARG", 32, "AR"},
	{"Asia", "South West Asia", "Armenia", "AM", "AM", "ARM", 51, "AM"},
	{"Americas", "West Indies", "Aruba", "AA", "AW", "ABW", 533, "AW"},
	{"Oceania", "Pacific", "Australia", "AS", "AU", "AUS", 36, "AU"},
	{"Europe", "Central Europe", "Austria", "AU", "AT", "AUT", 40, "AT"},
	{"Asia", "South West Asia", "Azerbaijan", "AJ", "AZ", "AZE", 31, "AZ"},
	{"Americas", "West Indies", "Bahamas, The", "BF", "BS", "BHS", 44, "BS"},
	{"Asia", "South West Asia", "Bahrain", "BA", "BH", "BHR", 48, "BH"},
	{"Asia", "South Asia", "Bangladesh", "BG", "BD", "BGD", 50, "BD"},
	{"Americas", "West Indies", "Barbados", "BB", "BB", "BRB", 52, "BB"},
	{"Europe", "Eastern Europe", "Belarus", "BO", "BY", "BLR", 112, "BY"},
	{"Europe", "Western Europe", "Belgium", "BE", "BE", "BEL", 56, "BE"},
	{"Americas", "Central America", "Belize", "BH", "BZ", "BLZ", 84, "BZ"},
	{"Africa", "Western Africa", "Benin", "BN", "BJ", "BEN", 204, "BJ"},
	{"Americas", "West Indies", "Bermuda", "BD", "BM", "BMU", 60, "BM"},
	{"Asia", "South Asia", "Bhutan", "BT", "BT", "BTN", 64, "BT"},
	{"Americas", "South America", "Bolivia", "BL", "BO", "BOL", 68, "BO"},
	{"Europe", "South East Europe", "Bosnia and Herzegovina", "BK", "BA", "BIH", 70, "BA"},
	{"Africa", "Southern Africa", "Botswana", "BC", "BW", "BWA", 72, "BW"},
	{"Americas", "South America", "Brazil", "BR", "BR", "BRA", 76, "BR"},
	{"Americas", "West Indies", "British Virgin Islands", "VI", "VG", "VGB", 92, "VG"},
	{"Asia", "South East Asia", "Brunei", "BX", "BN", "BRN", 96, "BN"},
	{"Europe", "South East Europe", "Bulgaria", "BU", "BG", "BGR", 100, "BG"},
	{"Africa", "Western Africa", "Burkina Faso", "UV", "BF", "BFA", 854, "BF"},
	{"Africa", "Central Africa", "Burundi", "BY", "BI", "BDI", 108, "BI"},
	{"Asia", "South East Asia", "Cambodia", "CB", "KH", "KHM", 116, "KH"},
	{"Africa", "Western Africa", "Cameroon", "CM", "CM", "CMR", 120, "CM"},
	{"Americas", "North America", "Canada", "CA", "CA", "CAN", 124, "CA"},
	{"Africa", "Western Africa", "Cape Verde", "CV", "CV", "CPV", 132, "CV"},
	{"Americas", "West Indies", "Cayman Islands", "CJ", "KY", "CYM", 136, "KY"},
	{"Africa", "Central Africa", "Central African Republic", "CT", "CF", "CAF", 140, "CF"},
	{"Africa", "Central Africa", "Chad", "CD", "TD", "TCD", 148, "TD"},
	{"Americas", "South America", "Chile", "CI", "CL", "CHL", 152, "CL"},
	{"Asia", "East Asia", "China", "CH", "CN", "CHN", 156, "CN"},
	{"Asia", "South East Asia", "Christmas Island", "KT", "CX", "CXR", 162, "CX"},
	{"Asia", "South East Asia", "Cocos (Keeling) Islands", "CK", "CC", "CCK", 166, "CC"},
	{"Americas", "South America", "Colombia", "CO", "CO", "COL", 170, "CO"},
	{"Africa", "Indian Ocean", "Comoros", "CN", "KM", "COM", 174, "KM"},
	{"Africa", "Central Africa", "Congo, Republic of the", "CF", "CG", "COG", 178, "CG"},
	{"Oceania", "Pacific", "Cook Islands", "CW", "CK", "COK", 184, "CK"},
	{"Americas", "Central America", "Costa Rica", "CS", "CR", "CRI", 188, "CR"},
	{"Africa", "Western Africa", "Cote d'Ivoire", "IV", "CI", "CIV", 384, "CI"},
	{"Europe", "South East Europe", "Croatia", "HR", "HR", "HRV", 191, "HR"},
	{"Americas", "West Indies", "Cuba", "CU", "CU", "CUB", 192, "CU"},
	{"Asia", "South West Asia", "Cyprus", "CY", "CY", "CYP", 196, "CY"},
	{"Europe", "Central Europe", "Czech Republic", "EZ", "CZ", "CZE", 203, "CZ"},
	{"Europe", "Northern Europe", "Denmark", "DA", "DK", "DNK", 208, "DK"},
	{"Africa", "Eastern Africa", "Djibouti", "DJ", "DJ", "DJI", 262, "DJ"},
	{"Americas", "West Indies", "Dominica", "DO", "DM", "DMA", 212, "DM"},
	{"Americas", "West Indies", "Dominican Republic", "DR", "DO", "DOM", 214, "DO"},
	{"Americas", "South America", "Ecuador", "EC", "EC", "ECU", 218, "EC"},
	{"Africa", "Northern Africa", "Egypt", "EG", "EG", "EGY", 818, "EG"},
	{"Americas", "Central America", "El Salvador", "ES", "SV", "SLV", 222, "SV"},
	{"Africa", "Western Africa", "Equatorial Guinea", "EK", "GQ", "GNQ", 226, "GQ"},
	{"Africa", "Eastern Africa", "Eritrea", "ER", "ER", "ERI", 232, "ER"},
	{"Europe", "Eastern Europe", "Estonia", "EN", "EE", "EST", 233, "EE"},
	{"Africa", "Eastern Africa", "Ethiopia", "ET", "ET", "ETH", 231, "ET"},
	{"Americas", "South America", "Falkland Islands (Islas Malvinas)", "FA", "FK", "FLK", 238, "FK"},
	{"Europe", "Northern Europe", "Faroe Islands", "FO", "FO", "FRO", 234, "FO"},
	{"Oceania", "Pacific", "Fiji", "FJ", "FJ", "FJI", 242, "FJ"},
	{"Europe", "Northern Europe", "Finland", "FI", "FI", "FIN", 246, "FI"},
	{"Europe", "Western Europe", "France", "FR", "FR", "FRA", 250, "FR"},
	{"Americas", "South America", "French Guiana", "FG", "GF", "GUF", 254, "GF"},
	{"Oceania", "Pacific", "French Polynesia", "FP", "PF", "PYF", 258, "PF"},
	{"Africa", "Western Africa", "Gabon", "GB", "GA", "GAB", 266, "GA"},
	{"Africa", "Western Africa", "Gambia, The", "GA", "GM", "GMB", 270, "GM"},
	{"Asia", "South West Asia", "Georgia", "GG", "GE", "GEO", 268, "GE"},
	{"Europe", "Western Europe", "Germany", "GM", "DE", "DEU", 276, "DE"},
	{"Africa", "Western Africa", "Ghana", "GH", "GH", "GHA", 288, "GH"},
	{"Europe", "South West Europe", "Gibraltar", "GI", "GI", "GIB", 292, "GI"},
	{"Europe", "South East Europe", "Greece", "GR", "GR", "GRC", 300, "GR"},
	{"Americas", "North America", "Greenland", "GL", "GL", "GRL", 304, "GL"},
	{"Americas", "West Indies", "Grenada", "GJ", "GD", "GRD", 308, "GD"},
	{"Americas", "West Indies", "Guadeloupe", "GP", "GP", "GLP", 312, "GP"},
	{"Oceania", "Pacific", "Guam", "GQ", "GU", "GUM", 316, "GU"},
	{"Americas", "Central America", "Guatemala", "GT", "GT", "GTM", 320, "GT"},
	{"Europe", "Western Europe", "Guernsey", "--", "--", "--", 0, "--"},
	{"Africa", "Western Africa", "Guinea", "GV", "GN", "GIN", 324, "GN"},
	{"Africa", "Western Africa", "Guinea-Bissau", "PU", "GW", "GNB", 624, "GW"},
	{"Americas", "South America", "Guyana", "GY", "GY", "GUY", 328, "GY"},
	{"Americas", "West Indies", "Haiti", "HA", "HT", "HTI", 332, "HT"},
	{"Europe", "Southern Europe", "Holy See (Vatican City)", "VT", "VA", "VAT", 336, "VA"},
	{"Americas", "Central America", "Honduras", "HO", "HN", "HND", 340, "HN"},
	{"Europe", "Central Europe", "Hungary", "HU", "HU", "HUN", 348, "HU"},
	{"Europe", "Northern Europe", "Iceland", "IC", "IS", "ISL", 352, "IS"},
	{"Asia", "South Asia", "India", "IN", "IN", "IND", 356, "IN"},
	{"Asia", "South East Asia", "Indonesia", "ID", "ID", "IDN", 360, "ID"},
	{"Asia", "South West Asia", "Iran", "IR", "IR", "IRN", 364, "IR"},
	{"Asia", "South West Asia", "Iraq", "IZ", "IQ", "IRQ", 368, "IQ"},
	{"Europe", "Western Europe", "Ireland", "EI", "IE", "IRL", 372, "IE"},
	{"Asia", "South West Asia", "Israel", "IS", "IL", "ISR", 376, "IL"},
	{"Europe", "Southern Europe", "Italy", "IT", "IT", "ITA", 380, "IT"},
	{"Americas", "West Indies", "Jamaica", "JM", "JM", "JAM", 388, "JM"},
	{"Europe", "Northern Europe", "Jan Mayen", "--", "--", "--", 0, "--"},
	{"Asia", "East Asia", "Japan", "JA", "JP", "JPN", 392, "JP"},
	{"Europe", "Western Europe", "Jersey", "--", "--", "--", 0, "--"},
	{"Asia", "South West Asia", "Jordan", "JO", "JO", "JOR", 400, "JO"},
	{"Asia", "Central Asia", "Kazakhstan", "KZ", "KZ", "KAZ", 398, "KZ"},
	{"Africa", "Eastern Africa", "Kenya", "KE", "KE", "KEN", 404, "KE"},
	{"Oceania", "Pacific", "Kiribati", "KR", "KI", "KIR", 296, "KI"},
	{"Asia", "East Asia", "Korea, North", "KN", "KP", "PRK", 408, "KP"},
	{"Asia", "East Asia", "Korea, South", "KS", "KR", "KOR", 410, "KR"},
	{"Asia", "South West Asia", "Kuwait", "KU", "KW", "KWT", 414, "KW"},
	{"Asia", "Central Asia", "Kyrgyzstan", "KG", "KG", "KGZ", 417, "KG"},
	{"Asia", "South East Asia", "Laos", "LA", "LA", "LAO", 418, "LA"},
	{"Europe", "Eastern Europe", "Latvia", "LG", "LV", "LVA", 428, "LV"},
	{"Asia", "South West Asia", "Lebanon", "LE", "LB", "LBN", 422, "LB"},
	{"Africa", "Southern Africa", "Lesotho", "LT", "LS", "LSO", 426, "LS"},
	{"Africa", "Western Africa", "Liberia", "LI", "LR", "LBR", 430, "LR"},
	{"Africa", "Northern Africa", "Libya", "LY", "LY", "LBY", 434, "LY"},
	{"Europe", "Central Europe", "Liechtenstein", "LS", "LI", "LIE", 438, "LI"},
	{"Europe", "Eastern Europe", "Lithuania", "LH", "LT", "LTU", 440, "LT"},
	{"Europe", "Western Europe", "Luxembourg", "LU", "LU", "LUX", 442, "LU"},
	{"Europe", "South East Europe", "Macedonia", "MK", "MK", "MKD", 807, "MK"},
	{"Africa", "Indian Ocean", "Madagascar", "MA", "MG", "MDG", 450, "MG"},
	{"Africa", "Southern Africa", "Malawi", "MI", "MW", "MWI", 454, "MW"},
	{"Asia", "South East Asia", "Malaysia", "MY", "MY", "MYS", 458, "MY"},
	{"Asia", "South Asia", "Maldives", "MV", "MV", "MDV", 462, "MV"},
	{"Africa", "Western Africa", "Mali", "ML", "ML", "MLI", 466, "ML"},
	{"Europe", "Southern Europe", "Malta", "MT", "MT", "MLT", 470, "MT"},
	{"Europe", "Western Europe", "Man, Isle of", "--", "--", "--", 0, "--"},
	{"Oceania", "Pacific", "Marshall Islands", "RM", "MH", "MHL", 584, "MH"},
	{"Americas", "West Indies", "Martinique", "MB", "MQ", "MTQ", 474, "MQ"},
	{"Africa", "Western Africa", "Mauritania", "MR", "MR", "MRT", 478, "MR"},
	{"Africa", "Indian Ocean", "Mauritius", "MP", "MU", "MUS", 480, "MU"},
	{"Africa", "Indian Ocean", "Mayotte", "MF", "YT", "MYT", 175, "YT"},
	{"Americas", "Central America", "Mexico", "MX", "MX", "MEX", 484, "MX"},
	{"Oceania", "Pacific", "Micronesia, Federated States of", "FM", "FSM", "583", 0, "--"},
	{"Europe", "Eastern Europe", "Moldova", "MD", "MD", "MDA", 498, "MD"},
	{"Europe", "Western Europe", "Monaco", "MN", "MC", "MCO", 492, "MC"},
	{"Asia", "Northern Asia", "Mongolia", "MG", "MN", "MNG", 496, "MN"},
	{"Americas", "West Indies", "Montserrat", "MH", "MS", "MSR", 500, "MS"},
	{"Africa", "Northern Africa", "Morocco", "MO", "MA", "MAR", 504, "MA"},
	{"Africa", "Southern Africa", "Mozambique", "MZ", "MZ", "MOZ", 508, "MZ"},
	{"Asia", "South East Asia", "Myanmar (Burma)", "BM", "MM", "MMR", 104, "MM"},
	{"Africa", "Southern Africa", "Namibia", "WA", "NA", "NAM", 516, "NA"},
	{"Oceania", "Pacific", "Nauru", "NR", "NR", "NRU", 520, "NR"},
	{"Asia", "South Asia", "Nepal", "NP", "NP", "NPL", 524, "NP"},
	{"Europe", "Western Europe", "Netherlands", "NL", "NL", "NLD", 528, "NL"},
	{"Americas", "West Indies", "Netherlands Antilles", "NT", "AN", "ANT", 530, "AN"},
	{"Oceania", "Pacific", "New Caledonia", "NC", "NC", "NCL", 540, "NC"},
	{"Oceania", "Pacific", "New Zealand", "NZ", "NZ", "NZL", 554, "NZ"},
	{"Americas", "Central America", "Nicaragua", "NU", "NI", "NIC", 558, "NI"},
	{"Africa", "Western Africa", "Niger", "NG", "NE", "NER", 562, "NE"},
	{"Africa", "Western Africa", "Nigeria", "NI", "NG", "NGA", 566, "NG"},
	{"Oceania", "Pacific", "Niue", "NE", "NU", "NIU", 570, "NU"},
	{"Oceania", "Pacific", "Norfolk Island", "NF", "NF", "NFK", 574, "NF"},
	{"Oceania", "Pacific", "Northern Mariana Islands", "CQ", "MP", "MNP", 580, "MP"},
	{"Europe", "Northern Europe", "Norway", "NO", "NO", "NOR", 578, "NO"},
	{"Asia", "South West Asia", "Oman", "MU", "OM", "OMN", 512, "OM"},
	{"Asia", "South Asia", "Pakistan", "PK", "PK", "PAK", 586, "PK"},
	{"Oceania", "Pacific", "Palau", "PS", "PW", "PLW", 585, "PW"},
	{"Asia", "South West Asia", "Palestine", "--", "--", "--", 0, "--"},
	{"Americas", "Central America", "Panama", "PM", "PA", "PAN", 591, "PA"},
	{"Oceania", "Pacific", "Papua New Guinea", "PP", "PG", "PNG", 598, "PG"},
	{"Americas", "South America", "Paraguay", "PA", "PY", "PRY", 600, "PY"},
	{"Americas", "South America", "Peru", "PE", "PE", "PER", 604, "PE"},
	{"Asia", "South East Asia", "Philippines", "RP", "PH", "PHL", 608, "PH"},
	{"Oceania", "Pacific", "Pitcairn Islands", "PC", "PN", "PCN", 612, "PN"},
	{"Europe", "Eastern Europe", "Poland", "PL", "PL", "POL", 616, "PL"},
	{"Europe", "South West Europe", "Portugal", "PO", "PT", "PRT", 620, "PT"},
	{"Americas", "West Indies", "Puerto Rico", "RQ", "PR", "PRI", 630, "PR"},
	{"Asia", "South West Asia", "Qatar", "QA", "QA", "QAT", 634, "QA"},
	{"Africa", "Indian Ocean", "Reunion", "RE", "RE", "REU", 638, "RE"},
	{"Europe", "South East Europe", "Romania", "RO", "RO", "ROM", 642, "RO"},
	{"Asia", "Northern Asia", "Russia", "RS", "RU", "RUS", 643, "RU"},
	{"Africa", "Central Africa", "Rwanda", "RW", "RW", "RWA", 646, "RW"},
	{"Americas", "West Indies", "Saint Kitts and Nevis", "SC", "KN", "KNA", 659, "KN"},
	{"Americas", "West Indies", "Saint Lucia", "ST", "LC", "LCA", 662, "LC"},
	{"Americas", "North America", "Saint Pierre and Miquelon", "SB", "PM", "SPM", 666, "PM"},
	{"Americas", "West Indies", "Saint Vincent and the Grenadines", "VC", "VC", "VCT", 670, "VC"},
	{"Europe", "Southern Europe", "San Marino", "SM", "SM", "SMR", 674, "SM"},
	{"Africa", "Western Africa", "Sao Tome and Principe", "TP", "ST", "STP", 678, "ST"},
	{"Asia", "South West Asia", "Saudi Arabia", "SA", "SA", "SAU", 682, "SA"},
	{"Africa", "Western Africa", "Senegal", "SG", "SN", "SEN", 686, "SN"},
	{"Europe", "South East Europe", "Serbia and Montenegro", "SR", "--", "--", 0, "--"},
	{"Africa", "Indian Ocean", "Seychelles", "SE", "SC", "SYC", 690, "SC"},
	{"Africa", "Western Africa", "Sierra Leone", "SL", "SL", "SLE", 694, "SL"},
	{"Asia", "South East Asia", "Singapore", "SN", "SG", "SGP", 702, "SG"},
	{"Europe", "Central Europe", "Slovakia", "LO", "SK", "SVK", 703, "SK"},
	{"Europe", "South East Europe", "Slovenia", "SI", "SI", "SVN", 705, "SI"},
	{"Oceania", "Pacific", "Solomon Islands", "BP", "SB", "SLB", 90, "SB"},
	{"Africa", "Eastern Africa", "Somalia", "SO", "SO", "SOM", 706, "SO"},
	{"Africa", "Southern Africa", "South Africa", "SF", "ZA", "ZAF", 710, "ZA"},
	{"Europe", "South West Europe", "Spain", "SP", "ES", "ESP", 724, "ES"},
	{"Asia", "South Asia", "Sri Lanka", "CE", "LK", "LKA", 144, "LK"},
	{"Africa", "Northern Africa", "Sudan", "SU", "SD", "SDN", 736, "SD"},
	{"Americas", "South America", "Suriname", "NS", "SR", "SUR", 740, "SR"},
	{"Europe", "Northern Europe", "Svalbard", "SV", "SJ", "SJM", 744, "SJ"},
	{"Africa", "Southern Africa", "Swaziland", "WZ", "SZ", "SWZ", 748, "SZ"},
	{"Europe", "Northern Europe", "Sweden", "SW", "SE", "SWE", 752, "SE"},
	{"Europe", "Central Europe", "Switzerland", "SZ", "CH", "CHE", 756, "CH"},
	{"Asia", "South West Asia", "Syria", "SY", "SY", "SYR", 760, "SY"},
	{"Asia", "East Asia", "Taiwan", "TW", "TW", "TWN", 158, "TW"},
	{"Asia", "Central Asia", "Tajikistan", "TI", "TJ", "TJK", 762, "TJ"},
	{"Africa", "Eastern Africa", "Tanzania", "TZ", "TZ", "TZA", 834, "TZ"},
	{"Asia", "South East Asia", "Thailand", "TH", "TH", "THA", 764, "TH"},
	{"Africa", "Western Africa", "Togo", "TO", "TG", "TGO", 768, "TG"},
	{"Oceania", "Pacific", "Tokelau", "TL", "TK", "TKL", 772, "TK"},
	{"Oceania", "Pacific", "Tonga", "TN", "TO", "TON", 776, "TO"},
	{"Americas", "West Indies", "Trinidad and Tobago", "TD", "TT", "TTO", 780, "TT"},
	{"Africa", "Northern Africa", "Tunisia", "TS", "TN", "TUN", 788, "TN"},
	{"Asia", "South West Asia", "Turkey", "TU", "TR", "TUR", 792, "TR"},
	{"Asia", "Central Asia", "Turkmenistan", "TX", "TM", "TKM", 795, "TM"},
	{"Americas", "West Indies", "Turks and Caicos Islands", "TK", "TC", "TCA", 796, "TC"},
	{"Oceania", "Pacific", "Tuvalu", "TV", "TV", "TUV", 798, "TV"},
	{"Africa", "Eastern Africa", "Uganda", "UG", "UG", "UGA", 800, "UG"},
	{"Europe", "Eastern Europe", "Ukraine", "UP", "UA", "UKR", 804, "UA"},
	{"Asia", "South West Asia", "United Arab Emirates", "TC", "AE", "ARE", 784, "AE"},
	{"Europe", "Western Europe", "United Kingdom", "UK", "GB", "GBR", 826, "UK/GB"},
	{"Americas", "North America", "United States", "US", "US", "USA", 840, "US"},
	{"Americas", "South America", "Uruguay", "UY", "UY", "URY", 858, "UY"},
	{"Asia", "Central Asia", "Uzbekistan", "UZ", "UZ", "UZB", 860, "UZ"},
	{"Oceania", "Pacific", "Vanuatu", "NH", "VU", "VUT", 548, "VU"},
	{"Americas", "South America", "Venezuela", "VE", "VE", "VEN", 862, "UE"},
	{"Asia", "South East Asia", "Vietnam", "VM", "VN", "VNM", 704, "VN"},
	{"Americas", "West Indies", "Virgin Islands", "VQ", "VI", "VIR", 850, "VI"},
	{"Oceania", "Pacific", "Wallis and Futuna", "WF", "WF", "WLF", 876, "WF"},
	{"Africa", "Northern Africa", "Western Sahara", "WI", "EH", "ESH", 732, "EH"},
	{"Oceania", "Pacific", "Western Samoa", "WS", "WS", "WSM", 882, "WS"},
	{"Asia", "South West Asia", "Yemen", "YM", "YE", "YEM", 887, "YE"},
	{"Africa", "Central Africa", "Zaire (Dem Rep of Congo)", "CG", "ZR", "ZAR", 180, "ZR"},
	{"Africa", "Southern Africa", "Zambia", "ZA", "ZM", "ZWB", 894, "ZM"},
	{"Africa", "Southern Africa", "Zimbabwe", "ZI", "ZW", "ZWE", 716, "ZW"},

	{nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, -1, nullptr}};

const LocaleInfo *GetFIPSCountry(const std::string &fips) {
	for (int i = 0; countries[i].iso != -1; ++i)
		if (fips == countries[i].fips)
			return &countries[i];
	return nullptr;
}

const LocaleInfo *GetISO2Country(const std::string &iso) {
	for (int i = 0; countries[i].iso != -1; ++i)
		if (iso == countries[i].iso2)
			return &countries[i];
	return nullptr;
}

const LocaleInfo *GetISO3Country(const std::string &iso) {
	for (int i = 0; countries[i].iso != -1; ++i)
		if (iso == countries[i].iso3)
			return &countries[i];
	return nullptr;
}

const LocaleInfo *GetISOCountry(int iso) {
	for (int i = 0; countries[i].iso != -1; ++i)
		if (iso == countries[i].iso)
			return &countries[i];
	return nullptr;
}

} // namespace hg
