.title Resources & Assets

By convention, production files are called **resources** (eg. *the project resources*).

Files issued from the compilation of production files for a specific target are called **assets** (eg. *the project assets for Windows PC*).

[TOC]

## Resource Formats

During development resources are stored in *production formats*, these formats are meant for editing. Before they can be loaded at runtime, resources must be compiled into their *runtime formats* as assets specific to the target platform.

To compile a project resources use:

```text
assetc <project_resources_folder> [<optional_project_assets_folder>]
```

If no output folder is specified the input folder suffixed with *_compiled* is implied.

Upon execution the assets compiler will scan the input folder and compile all supported resource types to assets. Unsupported resources are copied untransformed to the output folder.

The following table lists all supported resource types, their production and runtime formats.

Resource Type  | Production Format | Runtime Format
------------|-------------------|---------------
Texture     | jpg, png, tga, gif, bmp, psd, hdr, pic, pnm | Platform-specific (eg. RAW, ETC1, ETC2, BCx as DDS, PVR or TEX)
Shader      | GLSL-like meta language | Platform-specific (eg. HLSL, GLSL)
Pipeline Shader | GLSL-like meta language | Set of platform-specific shaders (eg. HLSL, GLSL)
Geometry    | Intermediate binary format | Packed index/vertex buffers
Lua         | Lua script | Lua bytecode as generated by `luac`
Physics     | JSON descriptor (see [man.Physics]) | Backend specific binary
Pathfinding | JSON descriptor (see [man.Navigation]) | Backend specific binary

One resource file may compile to multiple asset files.

For more information, see [man.AssetCompiler].

## Fine-tuning Resource Compilation

Most production formats need to be extended with additional information to control the compilation process. The asset compiler will look for an optional parameter file associated with each resource it compiles.

These parameter files are JSON dictionaries of key-value named as the resource file they extend suffixed with the `.meta` extension. The following table lists supported keys per resource type.

### Texture

Key            | Description                        | Possible Values         | Default Value
---------------|------------------------------------|-------------------------|------------------
`type`         | Hint in case a specific compression is not specified. | `Standard`, `NormalMap` | `Standard`
`max-size`     | Resize input if any axis exceeds the specified limit. | - | 16384
`compression`  | Explicit compression format. | `RAW`, `BC1`, `BC2`, `BC3`, `BC4`, `BC5`, `BC6H`, `BC7` | `RAW`
`generate-mips` | Generate mip levels. | `true`/`false` | `true`
`generate-probe` | For HDR latlong envmap, generate radiance/irradiance probes. | `true`/`false` | `false`

### Geometry

Key            | Description                        | Possible Values         | Default Value
---------------|------------------------------------|-------------------------|------------------
`cook-model`   | Generate a model from this geometry. | `true`/`false` | `true`

## Loading Assets at Runtime

All functions to load an asset type exist in at least two versions: one to load from the host filesystem and one to load from the assets packaging system. Here is a table listing both load functions for each asset type.

Asset Type  | Host Filesystem | Assets Packaging System
------------|-------------------|---------------
Texture     | [LoadTextureFromFile] | [LoadTextureFromAssets]
Shader      | [LoadProgramFromFile] | [LoadProgramFromAssets]
Pipeline Shader | [LoadPipelineProgramFromFile] | [LoadPipelineProgramFromAssets]
Model    | [LoadModelFromFile] | [LoadModelFromAssets]
Pathfinding | [LoadNavMeshFromFile] | [LoadNavMeshFromAssets]

Notice the change from the Geometry resource type to the Model asset type. A geometry holds much more information than its model counterpart which is optimized to only carry essential informations for displaying the input geometry accurately at runtime.

When loading an asset from the host filesystem, you can use its absolute or relative path. When using relative path the host filesystem lookup rules apply.

*It is recommend to not load assets from the host filesystem as it might make it harder to properly locate assets on disk.*

A better option is to use the assets packaging system, a virtual filesystem to which you can connect multiple data sources:

- A folder from the host filesystem, sandboxed with only its content and the content of its subfolders accessible.
- A zip archive to store assets as a single file on disk.

See [AddAssetsFolder]/[RemoveAssetsFolder] and [AddAssetsPackage]/[RemoveAssetsPackage].

Refer to [man.AssetCompiler] for how to compile resources to assets.
