# HanLP: Han Language Processing

[![GitHub stars](https://img.shields.io/github/stars/hankcs/HanLP)](https://github.com/hankcs/HanLP/stargazers) [![GitHub forks](https://img.shields.io/github/forks/hankcs/HanLP)](https://github.com/hankcs/HanLP/network) ![pypi](https://img.shields.io/pypi/v/HanLP) [![Downloads](https://static.pepy.tech/badge/HanLP)](https://pepy.tech/project/HanLP) [![GitHub license](https://img.shields.io/github/license/hankcs/HanLP)](https://github.com/hankcs/HanLP/blob/master/LICENSE) [![Open In Colab](https://file.hankcs.com/img/colab-badge.svg)](https://colab.research.google.com/drive/1KPX6t1y36TOzRIeB4Kt3uJ1twuj6WuFv?usp=sharing)

The multilingual NLP library for researchers and companies, built on PyTorch and TensorFlow 2.x, for advancing 
state-of-the-art deep learning techniques in both academia and industry. HanLP was designed from day one to be 
efficient, user friendly and extendable. It comes with pretrained models for various human languages 
including English, Chinese, Japanese and many others.



## Tutorials

```{toctree}
:maxdepth: 1
:caption: Introduction

tutorial
install
configure
data_format
annotations/index
contributing
Live Demo <https://hanlp.hankcs.com/>
```

## Python API

```{toctree}
:caption: Python API
:maxdepth: 2

api/hanlp/index
api/common/index
api/restful
api/trie/index
```

## Java API

```{toctree}
:maxdepth: 1
:caption: Java API

1.x API <https://github.com/hankcs/HanLP/tree/1.x>
api/restful_java
```

## Golang API

```{toctree}
:maxdepth: 1
:caption: Golang API

api/restful_golang
```

## References

```{toctree}
:caption: References
:maxdepth: 2

references
```


## Acknowledgements

HanLPv2.1 is heavily inspired by [AllenNLP](https://allennlp.org/) and [SuPar](https://pypi.org/project/supar/). 

[pypi-badge]: https://img.shields.io/pypi/v/hanlp.svg
[pypi-link]: https://pypi.org/project/hanlp

