<!--
# ========================================================================
# Copyright 2020 hankcs
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# ========================================================================
-->

# Universal Dependencies

## Cross-Linguistic

See also [Universal Dependencies](https://universaldependencies.org/docs/u/dep/index.html).

| Tag        | Description                                  |
|------------|----------------------------------------------|
| acl        | clausal modifier of noun (adjectival clause) |
| advcl      | adverbial clause modifier                    |
| advmod     | adverbial modifier                           |
| amod       | adjectival modifier                          |
| appos      | appositional modifier                        |
| aux        | auxiliary                                    |
| auxpass    | passive auxiliary                            |
| case       | case marking                                 |
| cc         | coordinating conjunction                     |
| ccomp      | clausal complement                           |
| compound   | compound                                     |
| conj       | conjunct                                     |
| cop        | copula                                       |
| csubj      | clausal subject                              |
| csubjpass  | clausal passive subject                      |
| dep        | unspecified dependency                       |
| det        | determiner                                   |
| discourse  | discourse element                            |
| dislocated | dislocated elements                          |
| dobj       | direct object                                |
| expl       | expletive                                    |
| foreign    | foreign words                                |
| goeswith   | goes with                                    |
| iobj       | indirect object                              |
| list       | list                                         |
| mark       | marker                                       |
| mwe        | multi-word expression                        |
| name       | name                                         |
| neg        | negation modifier                            |
| nmod       | nominal modifier                             |
| nsubj      | nominal subject                              |
| nsubjpass  | passive nominal subject                      |
| nummod     | numeric modifier                             |
| parataxis  | parataxis                                    |
| punct      | punctuation                                  |
| remnant    | remnant in ellipsis                          |
| reparandum | overridden disfluency                        |
| root       | root                                         |
| vocative   | vocative                                     |
| xcomp      | open clausal complement                      |


## Localization

### Chinese

| Tag              |       简称 |                                                         例句 |
| :--------------- |---------:| -----------------------------------------------------------: |
| acl              |    形容词子句 | ![acl](https://file.hankcs.com/img/ud/1303b5cbe9413044cb800b3c3514b70b.svg) |
| advcl:loc        |  状语从句修饰语 | ![advcl:loc](https://file.hankcs.com/img/ud/e8865563caf0eda7a80043eda8cc43a6.svg) |
| advmod           |       状语 | ![advmod](https://file.hankcs.com/img/ud/3ce9276f4e18d92edb48e58956bbaee7.svg) |
| advmod:dvp       |     状语:地 | ![advmod:dvp](https://file.hankcs.com/img/ud/e90870682b9f0a80736d25977565f96a.svg) |
| advmod:loc       |    状语:限定 | ![advmod:loc](https://file.hankcs.com/img/ud/135e9143e73e5f45290d204d4ad5b30e.svg) |
| advmod:rcomp     |    状语:因果 | ![advmod:rcomp](https://file.hankcs.com/img/ud/aa75be342648bed0846f54a88f71e7a7.svg) |
| amod             |       形容 | ![amod](https://file.hankcs.com/img/ud/dee0097c244c1bd0a1d1ed117932346d.svg) |
| amod:ordmod      |    形容:数量 | ![amod:ordmod](https://file.hankcs.com/img/ud/8bb79245311a4190836dce8439591e91.svg) |
| appos            |       同位 | ![appos](https://file.hankcs.com/img/ud/a74f6a31f68ba5697d0a8906e8476b47.svg) |
| aux:asp          |    助语:时态 | ![aux:asp](https://file.hankcs.com/img/ud/8c32de9b4858c0e4d24ee6da5fb80a6e.svg) |
| aux:ba           |     助语:把 | ![aux:ba](https://file.hankcs.com/img/ud/2c712e3af49fcdbd5914398895904f3c.svg) |
| aux:modal        |    助语:情态 | ![aux:modal](https://file.hankcs.com/img/ud/606946c569e4bfbacbb1b9e13336e247.svg) |
| aux:prtmod       |    助语:分词 | ![aux:prtmod](https://file.hankcs.com/img/ud/fc49d338487dd63687941433a0633f5d.svg) |
| auxpass          |       被动 | ![auxpass](https://file.hankcs.com/img/ud/a6e4a8aabb7bb1bb5c4e9cdf7876e3f7.svg) |
| case             |       条件 | ![case](https://file.hankcs.com/img/ud/35a021e15a9355880cb8720ba34ed936.svg) |
| cc               |     并列连词 | ![cc](https://file.hankcs.com/img/ud/18c6a22520cec2ba60ce636bb410f651.svg) |
| ccomp            |     从句补语 | ![ccomp](https://file.hankcs.com/img/ud/8cc4ea0c6a090f1ba03d02926240c35b.svg) |
| compound:nn      |     复合名词 | ![compound:nn](https://file.hankcs.com/img/ud/587e12141aa42aa9862ea0ac0eb30e09.svg) |
| compound:vc      |     复合动词 | ![compound:vc](https://file.hankcs.com/img/ud/f72cedcb6cec8563d88063b118544a9d.svg) |
| conj             |       连接 | ![conj](https://file.hankcs.com/img/ud/fc924f495d1d5a3a828a0e2262da06cd.svg) |
| cop              |       系动 | ![cop](https://file.hankcs.com/img/ud/a7da58f57adbe9e6bd166ecb514f2d1c.svg) |
| csubj            |     从句主语 | ![csubj](https://file.hankcs.com/img/ud/0adda481e81b3765ed7f4f9d55c153c4.svg) |
| dep              |      未定义 | ![dep](https://file.hankcs.com/img/ud/db15b792f1bfd5e42982832b04c65a79.svg) |
| det              |       限定 | ![det](https://file.hankcs.com/img/ud/17376d13a4e7b0677cd18d13e0990dab.svg) |
| discourse        |       语气 | ![discourse](https://file.hankcs.com/img/ud/d7eb37d5fd13462b237140a08f0ed9a4.svg) |
| dobj             |     直接宾语 | ![dobj](https://file.hankcs.com/img/ud/f5e801103ddc57a9aeff0e272b8f7b44.svg) |
| etc              |       省略 | ![etc](https://file.hankcs.com/img/ud/86d3fd24cae9f585b7730119edaa0248.svg) |
| mark             |       标记 | ![mark](https://file.hankcs.com/img/ud/b17b4027ab368c76a3b6f085d5b561d9.svg) |
| mark:clf         |    标记:量词 | ![mark:clf](https://file.hankcs.com/img/ud/5974c92e3587aa64ba1d572243b9c5cc.svg) |
| name             |       名称 | ![name](https://file.hankcs.com/img/ud/63ea082457dfe6f4fc04f635a8c019f3.svg) |
| neg              |       否定 | ![neg](https://file.hankcs.com/img/ud/e38814231ff9a31dcce5672556375c94.svg) |
| nmod             |     名词修饰 | ![nmod](https://file.hankcs.com/img/ud/e948a8dbcd43984d14c257f0ace1753d.svg) |
| nmod:assmod      |  名词修饰:关联 | ![nmod:assmod](https://file.hankcs.com/img/ud/76349f30cef2c4978a03118d65ac6c81.svg) |
| nmod:poss        | 名词修饰:所有格 | ![nmod:poss](https://file.hankcs.com/img/ud/5b4937dbea42cdff7054e9dd0904bedb.svg) |
| nmod:prep        |  名词修饰:介词 | ![nmod:prep](https://file.hankcs.com/img/ud/63b92981638b758681a82e9f4a9aa04c.svg) |
| nmod:range       |  名词修饰:范围 | ![nmod:range](https://file.hankcs.com/img/ud/217ec98756cfe3750c76f5e5e89b7f54.svg) |
| nmod:tmod        |  名词修饰:时间 | ![nmod:tmod](https://file.hankcs.com/img/ud/166e3b8fb72db52f0ec332d444ea017f.svg) |
| nmod:topic       |  名词修饰:主题 | ![nmod:topic](https://file.hankcs.com/img/ud/93c83c98c188b131211ac5e9ff5242c0.svg) |
| nsubj            |     名词主语 | ![nsubj](https://file.hankcs.com/img/ud/63e3902d4a3045d1d696a0c4ed203563.svg) |
| nsubj:xsubj      | 名词主语: 补语 | ![nsubj:xsubj](https://file.hankcs.com/img/ud/80cb355b9f9732fd888186a1f658b0ac.svg) |
| nsubjpass        |    被动态主语 | ![nsubjpass](https://file.hankcs.com/img/ud/6327fab58ab42d5a417b2e5c7018ac3a.svg) |
| nummod           |       数量 | ![nummod](https://file.hankcs.com/img/ud/0fd20559645265c2c937f06631aa74df.svg) |
| parataxis:prnmod |       并列 | ![parataxis:prnmod](https://file.hankcs.com/img/ud/783a0faf4cd935bb61f5d225a388b79e.svg) |
| punct            |     标点符号 | ![punct](https://file.hankcs.com/img/ud/983410055658352080ae476a5d85e6b5.svg) |
| root             |        根 | ![root](https://file.hankcs.com/img/ud/588101bec0440ffb769172f8b7e9f98e.svg) |
| xcomp            |     从句补语 | ![xcomp](https://file.hankcs.com/img/ud/c72071875f1c01e51acb9e1ec4893113.svg) |
