<!--
# ========================================================================
# Copyright 2020 hankcs
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# ========================================================================
-->

# Stanford Dependencies English

See also [Stanford typed dependencies manual](https://nlp.stanford.edu/software/dependencies_manual.pdf).

| Tag        | Description                       |
|------------|-----------------------------------|
| abbrev     | abbreviation modifier             |
| acomp      | adjectival complement             |
| advcl      | adverbial clause modifier         |
| advmod     | adverbial modifier                |
| agent      | agent                             |
| amod       | adjectival modifier               |
| appos      | appositional modifier             |
| arg        | argument                          |
| attr       | attributive                       |
| aux        | auxiliary                         |
| auxpass    | passive auxiliary                 |
| cc         | coordination                      |
| ccomp      | clausal complement                |
| comp       | complement                        |
| complm     | complementizer                    |
| conj       | conjunct                          |
| cop        | copula                            |
| csubj      | clausal subject                   |
| csubjpass  | clausal passive subject           |
| dep        | dependent                         |
| det        | determiner                        |
| discourse  | discourse element                 |
| dobj       | direct object                     |
| expl       | expletive                         |
| goeswith   | goes with                         |
| iobj       | indirect object                   |
| mark       | marker                            |
| mod        | modifier                          |
| mwe        | multi-word expression             |
| neg        | negation modifier                 |
| nn         | noun compound modifier            |
| npadvmod   | noun phrase as adverbial modifier |
| nsubj      | nominal subject                   |
| nsubjpass  | passive nominal subject           |
| num        | numeric modifier                  |
| number     | element of compound number        |
| obj        | object                            |
| parataxis  | parataxis                         |
| pcomp      | prepositional complement          |
| pobj       | object of a preposition           |
| poss       | possession modifier               |
| possessive | possessive modifier               |
| preconj    | preconjunct                       |
| pred       | predicate                         |
| predet     | predeterminer                     |
| prep       | prepositional modifier            |
| prepc      | prepositional clausal modifier    |
| prt        | phrasal verb particle             |
| punct      | punctuation                       |
| purpcl     | purpose clause modifier           |
| quantmod   | quantifier phrase modifier        |
| rcmod      | relative clause modifier          |
| ref        | referent                          |
| rel        | relative                          |
| root       | root                              |
| sdep       | semantic dependent                |
| subj       | subject                           |
| tmod       | temporal modifier                 |
| vmod       | verb modifier                     |
| xcomp      | open clausal complement           |
| xsubj      | controlling subject               |