<!--
# ========================================================================
# Copyright 2020 hankcs
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# ========================================================================
-->

# PKU Multi-view Chinese Treebank


```{eval-rst}

See also :cite:`qiu-etal-2014-multi`.
    
```

| Tag  | Description                                 | 依存关系       |
| ---- | ------------------------------------------- | -------------- |
| ACT  | action object                               | 行为宾语       |
| ADV  | adverbial                                   | 状语           |
| APP  | appositive element                          | 同位           |
| ATT  | attribute                                   | 定语           |
| CMP  | complement                                  | 补语           |
| COO  | other coordination element                  | 一般并列       |
| COS  | share-right-child coordination element      | 共享并列       |
| DE   | de (modifier of 的(special function word))  | 的字           |
| DEI  | dei (modifier of 得(special function word)) | 得字           |
| DI   | di (modifier of 地(special function word))  | 地字           |
| FOC  | focus                                       | 强调           |
| HED  | root of a sentence                          | 核心           |
| IC   | independent clause                          | 小句           |
| IOB  | indirect object                             | 间接宾语       |
| IS   | independent structure                       | 独立结构       |
| ISC  | non-shared independent structure            | 并列式独立结构 |
| LAD  | left additive                               | 前附加         |
| MT   | modality and time                           | 时体           |
| NUM  | number                                      | 数字           |
| POB  | propositional object                        | 介宾           |
| PUN  | punctuation                                 | 标点           |
| PUS  | cross-clause punctuation                    | 跨句标点       |
| QUC  | post-positional quantity                    | 数量补语       |
| QUCC | non-shared post-positional quantity         | 非共享数量补语 |
| QUN  | quantity                                    | 数量           |
| RAD  | right additive                              | 后附加         |
| RADC | non-shared right additive                   | 非共享后附加   |
| RED  | reduplicate element                         | 重叠           |
| SBV  | subject                                     | 主语           |
| TPC  | topic                                       | 话题           |
| VOB  | direct object                               | 宾语           |
| VV   | serial verb construction                    | 连动           |
