## 数据类型及大小

char 字符型 1 byte

short 短整型 2 byte

int 整型 4 byte

long 长整型 4 byte

long long 更长的整型 8 byte

float 单精度浮点型 4 byte

double 双精度浮点型 8 byte

long double        16 byte

### 看大小的程序：

```
#include<stdio.h>
int main(){
	printf("%d\n",sizeof(long));
	printf("%d\n",sizeof(long double));
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

## 定义变量的位置

```c
int main()
{
	int num1 = 0;
	int num2 = 0;
	printf("请输入两个数字:>");
	scanf("%d%d", &num1, &num2);
	int sum = num1+num2;
        printf("sum = %d\n", sum);

	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

 有的编译器会在这里提示错误，因为c规定对变量的声明应该在函数的开头。

修改后：

```
int main()
{
	int num1 = 0;
	int num2 = 0;
	int sum = 0;
	printf("请输入两个数字:>");
	scanf("%d%d", &num1, &num2);
	sum = num1+num2;
        printf("sum = %d\n", sum);

	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

这样应该就不会有问题了

## 关于变量的作用域和生存期

注意变量的作用域

```
int main()
{
	{
		int a = 10; //对变量a的声明再括号内，所以a的作用域仅在括号内
	}
	printf("a = %d\n", a);

	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

 外部变量引用

```
//声明外部符号（仅需要再同一个项目的另一个c文件中声明这个变量即可，可以直接调用）
extern int g_val;

int  main()
{
	printf("g_val = %d\n", g_val);
	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

### 全局变量的注意事项：先声明，后引用

大家思考下面这个代码sum函数是否可以算出a+b的和

```
#include<stdio.h>

int sum(int x){

	return x+a;
}
int a=2;   //a 声明在sum函数后
int main(){
	int b=2; 
	
	printf("%d",sum(b));
	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

运算结果并不是我们像要的，应该如何修改呢？

只需要将对 a的声明放在要调用a的sum函数前即可



```
#include<stdio.h>
int a=2;     //
int sum(int x){

	return x+a;
}

int main(){
	int b=2; 
	
	printf("%d",sum(b));
	return 0;
} 
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

也有例外，供大家思考

```
#include<stdio.h>
int sum(int x,int y){
	return x+y;
}
int a=2;       
int main(){
	int b=2; 
	
	printf("%d",sum(a,b));
	return 0;
} 
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

## 总而言之，一定要在引用变量前声明变量，就算是全局变量

##  

## 常量的类型

### 1.字面常量

如：3.14,"abc" ,'a'

### 2.const 修饰的常变量

声明方式const int num = 10

一般来说常变量无法再赋其他值

常变量依然是变量，并不是常量（int arr[num] = {0}；这个语句是有错误提示的，证明num并不是常量）

### 3.#define定义的标识符常量

```
#include<stdio.h>
#define MAX 10
int main(){
	int a=MAX;
	printf("%d",a);
}

//输出结果为10
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

### 4. 枚举常量

```
enum Sex
{
	MALE,
	FEMALE=5,
	SECRET
};
#include<stdio.h>
int main(){
	printf("%d\n", MALE);
	printf("%d\n", FEMALE);
	printf("%d\n", SECRET);
	return 0;
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

![img](https://img-blog.csdnimg.cn/20191205005759730.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQ0OTU0MDEw,size_16,color_FFFFFF,t_70)![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

enum 枚举类型常量 如果没有赋予其他处置默认从0开始递增。

## 字符串的一个重要问题

```c
char arr1[] = "abc";
char arr2[] = {'a', 'b', 'c'};
printf("%s\n", arr1);
printf("%s\n", arr2);
```



思考一下上述两个printf函数会输出什么？是否一样？

结果是

arr1可以正常输出

但是arr2却在输出abc后出现了乱码（这个乱码是随机的，可能出现也可能不出现）

为什么会这样？

因为c语言中会在字符串后面自动加上空字符'\0'，它代表着字符串的结束

再输出arr2过程中由于后面没有终止符，系统会继续向下搜寻，而后面是什么内容是未知的，因此会出现乱码。

```c
printf("%d\n", strlen(arr1));//string length
printf("%d\n", strlen(arr2));
```



字符串的长度都是3

## 转义字符的重要用法

如果我想输出目录“ c:\test\090\test.c”用下面代码输出是否可以？

```
#include<stdio.h>
int main(){
	printf("c:\test\070\test.c");
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

输出结果竟然是：c:   est8  est.c

为什么会这样？因为‘\’是一个转义字符，‘\t’为水平制表符 会进行缩进

那么应该正确的输出我们想要的结果呢？

我们只需要再'\'之前再加上一个'\'再次进行转义就好了

### \ddd ddd表示1~3个八进制的数字

### \xdd dd表示2个十六进制数字

注：八进制数位上最大值为7



以上就是本次关于c语言要点的归纳，感谢观看

