### **如何用程序判断自己的机器是大端还是小端？**

通常情况下，我们的计算机都是小端存储模式。

> 小端：数字的低位存储到内存的低地址上。
> 大端：数字的低位存储到内存的高地址上。

我们在 VS 中创建一个临时变脸

```
 int a = 0x11223344;// 十六进制数
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

然后打开调试器，看到变量 a 在内存中是这样存储的：

```
 0x0133FC50  44 33 22 11
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

对于 Vs 调试中内存窗口的这行信息应该如何理解呢？它就表示：

![img](https://imgconvert.csdnimg.cn/aHR0cHM6Ly9waWM0LnpoaW1nLmNvbS84MC92Mi1mNGE3OGNlNTdmZTUwYzNlOTcwMDM1OWM2MGFlZTMzN183MjB3LmpwZw?x-oss-process=image/format,png)![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

十六进制数每两位表示一个字节，地址也是十六进制数；int 类型在 32 位机器上大小为 4 个字节。



**如何理解十六进制数每两位表示一个字节？**

十六进制数每一位的取值范围是 0 ~ 15，表示 16 种不同可能，对应 4 个二进制位（0000 ~ 1111），所以每一位十六进制可以表示 4 个二进制位，那么两个十六进制位就表示 8 个二进制位，也就是 1 个字节。



可以看到，在我的机器上，低位 44 存储在 低地址（0x0133FC50）上，所以我的机器是 小端存储模式。



如果是大端存储模式，变量 a 在内存中的存储应该如下图所示：

![img](https://imgconvert.csdnimg.cn/aHR0cHM6Ly9waWMxLnpoaW1nLmNvbS84MC92Mi00ZmI1YWJmN2Q3OWYwNzU5OTM5ZjBhMjliYzRkMzlhY183MjB3LmpwZw?x-oss-process=image/format,png)![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

现在，让我们用程序来验证一下我们的机器到底是大端还是小端。



### **方法一**

```
 #include<stdio.h>
 
 int main(void) {
 
     int a = 0x11223344;
     int* pi = &a;
     char* pc = (char*)pi;//指针强转
 
     printf("%x\n", *pc);//输出 44 ，得到证实
 
     return 0;
 }
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)



### **方法二**

```
 #include<stdio.h>
 
 typedef union {
     int a;
     char ch[sizeof(int)];
 }BOS;//big or small
 
 int main(void) {
 
     BOS bos;
     bos.a = 0x11223344;
 
     printf("%x", (unsigned int)bos.ch[0]);//输出 44
 
     return 0;
 }
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)



**如果本文你有地方没有看懂，推荐阅读以下文章，可以帮助你理解**：

- [一文看懂枚举&结构&联合](https://mp.weixin.qq.com/s/NkXZSdM-gnAuG7_jAM8ZiA)



