# 字符串入门
### 字符串基础：
#### 基本概念：
- 以 0 结尾的一串字符
- 0 和 '\0' 是一样的，但是与 ’0‘ 不同
- 0标志着字符串的结束，但它不是字符串的一部分
- 计算字符串长度不包括这个0
- 字符串以数组的形式存在，以数组或指针的形式访问（更多以指针形式）
- 头文件 string.h

#### 表示方法
```c
char* str = "Hello";
char string[] = "Hello";
char line[10] = "Hello";
```
#### 字符串常量
- 形如"Hello"这样**被双引号引起来的字符串**就叫字符串常量（字面量）
- **字符串常量**："Hello"
**大小** 6  加上结尾表示结束的0
- C的编译器会将**两个连续的字符串连接起来**
- 字符串常量通常放在 `代码段`，这个区域的数据通常是只读的

比如：
```c
printf("Hello","world");
```
这样会输出
```c
Hello World
```
**或者你也可以这样写：**
这种写法在我的计算机上提示有语法错误，那位大佬能指导一下？（翁恺老师可以在这样写，难道是C99语法。。。）
```c
printf("Hello \
World");
```
#### 注意
- 不能对字符串做运算
- 可通过数组方式遍历字符串
- 可以通过字符串常量来初始化字符串数组

### 字符串输入输出
```c
char* str = "Hello";
//输入
scanf("%s",string);
//输出
printf("%s",string);
```
**读取方式**

可以用以下程序测试：
```c
int main() {

	char str1[4];
	char str2[4];

	scanf("%s", str1);
	scanf("%s", str2);

	printf("%s##%s", str1, str2);

	return 0;
}
```

- `scanf`读入一个单词（遇到 **空格**，**tab**，**回车** 结束）
- `scanf`不安全，因为不知道读入的内容的长度

**安全的输入**
>`scanf("%3s",str1)`
>% 与 s 之间的数字表示，最多允许读入的字符数量，这个数的最大值应该等于 `数组大小 - 1`

请看下面的程序：
分别输入以下两组值，会输出什么？
 1234 1234 
 123 123
```c
int main() {

	char str1[4];
	char str2[4];

	scanf("%3s", str1);
	scanf("%s", str2);

	printf("%s##%s", str1, str2);

	return 0;
}
```

```c
//1
123 4
//2
123 123
```
![](https://img-blog.csdnimg.cn/2020020422550928.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQ0OTU0MDEw,size_16,color_FFFFFF,t_70 =200x200)
**注意**
`char buffer[100] = ""`（""是紧挨的，下同）
它的意思是 `buffer[0] == '\0'` 表示空字符串
`char buffer[] = ""`  
它表示字符串长度为1

我们不妨来测试一下：
```c
int main() {

	char buffer1[100] = "";
	char buffer2[] = "";

	printf("%c  %d\n", buffer1[0], sizeof(buffer1));
	printf("%c  %d\n", buffer2[0], sizeof(buffer2));

	return 0;
}
```
输出
```c
   100
   1
```
**0 用%c 的格式输出为空格**

### 字符串数组 — 指针数组的一类
这里我们重点介绍 字符串数组。什么是指针数组，可以参考我CSDN上的这篇文章：
[[C语言复习巩固]指针（入门）](https://blog.csdn.net/qq_44954010/article/details/103742120)

#### char* str1[5] 与char str2[5][10]
![char* a[] 与char a[][10]在栈中的不同](https://img-blog.csdnimg.cn/20200205151248503.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQ0OTU0MDEw,size_16,color_FFFFFF,t_70)
从上图可以看出，char* str1[5] 内存放的是**字符串的指针**，指向了一个地址
而char str2[5][10]则是在栈中开辟了50char大小的空间来存放这些字符

下面的程序通过初始方式来帮助你理解两者的不同：
```c
int main() {

	char Str1[10] = "Hello";
	char Str2[10];
	char Str3[10];
	char Str4[10];
	char Str5[10] = "World";

	char* str1[5] = {Str1, Str2, Str3, Str4, Str5};
	char str2[5][10] = {
	          "Hello",//注意写逗号
	           "",
	           "",
			   "",
	           "World"};
	
	str1[1] = " Goodbye";
	//str2[1] = " Goodbye";//报错：表达式必须是可修改的左值
	scanf("%s", str2[1]);

	printf("%s", str1[0]);
	printf("%s\n", str1[4]);
	printf("%s ", str2[0]);
	printf("%s\n", str2[4]);

	return 0;
}
```
#### 字符串数组的一个应用
**写一个程序。输入一个数代表月份，输出这个月的英语单词。**

我们可以用 if else 来做也可以用 switch 来做。但是今天学习了字符串数组，我们有了更简单的方式来完成。

请看下面的程序：
```c
int main() {

	char* str[12] = {	"January",	"February",	"March",	"April",	"May",	"June",	
		"July",	"August",	"September",	"October",	"November",	"Decenmber",
	};
	int month = 0;

	while (1) {
		printf("input a month\n");
		scanf("%d", &month);

		if (month >= 1 && month <= 12)
			printf("%s\n", str[month - 1]);
		else
			printf("invalid input\n");
	}

	return 0;
}
```
这样写代码被大大缩短了

#### main函数的参数？
通常我们写 main 函数会这样写：
`int main()` ，这样写其实并不严谨。
但这并不是大家的错，是谭老师没教好。
如果你的main函数没有参数，从今天起我们都这样写`int main(void)`，为什么呢？
首先你的main函数和大多初学者不一样，可以装一装大佬。
![](https://img-blog.csdnimg.cn/2020020516121023.jpg?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQ0OTU0MDEw,size_16,color_FFFFFF,t_70 =200x200)
其次，我们知道，main函数也是函数，是被其他函数调用的。这个在我函数的文章中讲解过。感兴趣的朋友可以看一下。[点击查看](https://mp.weixin.qq.com/s/JEalmGOwNXp9IM0W7B7YJw)

这是mian函数有参数的形式（我们在这里简化了一下，方便理解）
`int main(int argc, char* argv[])`
![](https://img-blog.csdnimg.cn/20200205161524446.jpg?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQ0OTU0MDEw,size_16,color_FFFFFF,t_70 =250x200)
>`int argc` 是字符串数组`char* argv[]`的大小 （也称“参数计数” ，是命令行参数的数量） 
>`int argv[]` 也称“参数向量” 是指向命令行参数的指针数组
>`argv[0]`指向可执行程序的名称（.exe）
>`argv[1] ~ argv[argc - 1]`  指向实际参数，也就是命令行
>`argv[argc]`是空指针NULL

如果你不知道我上面写的是什么，那么就要注意啦！其他的都是开玩笑，这里才是这一节的重点。
***
一下内容面向小白，大佬可以跳过这一段

什么是命令行？

看完这篇文章后，去搜索一下linux是什么以及linux对程序员有什么用相关问题。如果你有收获，分享一下这篇文章不过分吧

命令行说白了就是一个替代你鼠标的东西，它可以让你更加高效的去做很多事情。
比如在win10下你在键盘上按下 `win + R` 然后再跳出的窗口里输入 `cmd` 打开的小黑窗口其实就是命令行窗口。在这个窗口里你可以输入指令，来完成各种事情。比如基础的`dir` 展示当前目录下内容 `cd`进入文件夹
`cd .. `退出文件夹等等。
***
为了更深入的了解mian函数的参数有什么用，我们在实际的程序中来感受一下。

**用main函数的参数实现的 命令行中 两个整数的 四则运算**

先看一下程序运行的效果：
![](https://img-blog.csdnimg.cn/20200205182745931.gif)
关注公众号后台回复 【2020 0205】获得源码以及详细讲解