# C语言——猜数字小游戏

## 如何用rand，srand，time来完成随机数发生

------

这是这款小游戏的简单玩法。期待着与你一同完善，改进这个小游戏！

------

接下来我们看一下如何来实现这样一个游戏。
纵观这个游戏，我们发现，这个游戏的难点其实就是**如何生成一个随机数**。
生成随机数我们这里用到了三个个函数分别是：

- `rand()`
- `srand()`
- `time()`

由于生成随机数是我们这个游戏的核心，我们把这三个函数在这里细讲一下

------

> **`int rand()`**
> **头文件**：stdlib.h
> **定义**：srand() 播种 rand() 所用的伪随机数生成器。若在任何对 srand() 的调用前使用 rand() ，则 rand() 表现如同它以 srand(1) 播种。每次以 srand() 播种 rand() 时，它必须产生相同的值数列。
> **返回值**：返回 ​0​ 与 RAND_MAX 间的随机整数值（包含 0 与 RAND_MAX ）。
> **`void srand( unsigned seed )`**
> **头文件**：stdlib.h
> **定义**：以值 seed 播种 rand() 所用的随机数生成器。若在任何到 srand() 的调用前使用 rand() ，则 rand() 表现为如同它被以 srand(1) 播种。每次以同一 seed 播种 rand() 时，它必须产生相同的值数列。
> **返回值**：无

是不是听了之后很懵逼？没关系，请看下面的例子

```
//大家可以用自己的编译器反复运行下面的代码，可以发现，每次产生的五个数都是一样的。
#include<stdio.h>
#include<stdlib.h>
int main() {
    int x = 0;
    int test = 5;
    int i = 0;
    i = test;
    //srand(1);//不写srand函数是默认srand内参数为1
    while (i--) {
        x = rand()%10 + 1;
        printf("%d ", x);
    }
    printf("\n");
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

```
//这时候我们调用srand函数并且改变参数，再次观察产生的随机序列，会发现这次的五个数和之前的不同了
#include<stdio.h>
#include<stdlib.h>
int main() {
    int x = 0;
    int test = 5;
    int i = 0;
    i = test;
    srand(2);
    while (i--) {
        x = rand() % 10 + 1;
        printf("%d ", x);
    }
    printf("\n");
}
//这就说明了srand内的参数可以让rand函数产生不同的序列，但是这些序列并不是随机的。
//如果我们要产生随机数，就必须不断改变srand函数内的参数，这时我们就需要引入time函数。
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

> **`time_t time( time_t \*arg )`**
> **头文件**：time.h
> **定义**：返回编码成 time_t 对象的当前日历时间，并将其存储于 arg 指向的 time_t 对象（除非 arg 为空指针）
> **参数**：arg - 指向将存储时间的 time_t 对象的指针，或空指针
> **返回值**：成功时返回编码成 time_t 对象的当前日历时间。错误时返回 (time_t)(-1) 。若arg不是空指针，则返回值也会存储于 arg 所指向的对象。
>
> ------
>
> 需要注意的是，在我的32位的vs2019编译器上，time_t的类型是long long

对于time的用法请看下例

```
#include<stdio.h>
#include<stdlib.h>
#include<time.h>
int main() {
    time_t t1, t2;
    t1 = time(NULL);//传入空指针，需要用t1接收返回的时间
    time(&t2);//传入指针，当前的时间戳写入t2
    printf("%lld\n",t1);
    printf("%lld\n",t2);
}
//两个printf输出的数相同
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

------

**综上所述，我们把time函数返回的随时变化的时间戳（从1970年1月1日至今）当作srand函数的参数，这样就可以让rand每次产生的数列都是不同的，随机的**
**切记要在使用rand函数前先调用srand函数哦！**

------

它们组合起来怎么写呢？我们可以这么来写：

```
#include<stdio.h>
#include<stdlib.h>
#include<time.h>
int main() {
    srand((unsigned)time(NULL));//关注一下srand函数的参数类型
    int i = 0;
    int random = 0;
    for (; i < 5; i++) {
        random = rand();
        printf("%d ", random);
    }
}
```

![点击并拖拽以移动](data:image/gif;base64,R0lGODlhAQABAPABAP///wAAACH5BAEKAAAALAAAAAABAAEAAAICRAEAOw==)

------

想必大家看到了我的程序还有一个让你选择猜数范围的功能，那么它又是怎么实现的呢？
其实也很简单，核心就是**求余**
假如你想猜数的范围是1~10
rand函数产生数是随机数，用 `rand() % 10` 得到的范围是 0~9 那就再给它加上1就好了，其他范围都是这个道理

------



[猜数字游戏完整源代码](https://github.com/hairrrrr/project/tree/master/C games/guessing-number)

