## 介绍 

帮助 C 语言初学者的从入门到“精通”

<br>

<div align="center">
    <a href="#"> <img src="https://img.shields.io/badge/language-C-orange"></a>
    <a href="#weixin"> <img src="https://img.shields.io/badge/%E5%BE%AE%E4%BF%A1%E5%85%AC%E4%BC%97%E5%8F%B7-%E4%B8%8D%E4%BC%9A%E7%BC%96%E7%A8%8B%E7%9A%84%E7%A8%8B%E5%BA%8F%E5%9C%86-blue"></a>
</div>

<br>

<div align="center">
    <img src="https://hairrrrr.github.io/assets/logo.png" width="200px">
</div>

<br>

## 声明  

本仓库内容除了少部分引用书籍和技术文档的部分内容（均在文中末尾指出），其余都是我的原创。在您引用本仓库内容或者对内容进行修改演绎时，请署名并以相同方式共享，谢谢。

转载文章请在开头明显处标明该页面地址。

<br>

<div>

## 导航

1.  <a  href="#catalogue">学习 C 语言</a>
2. <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/other/Q%26A.md">C 语言 Q&A</a>
3. <a href="#practice">C 经典练习题</a>
4. <a href="#game">用 C 实现的小游戏</a>
5. <a href="#exam">C 课程设计作业 </a>
6. <a href="#get">免费获取 C 语言必读经典电子书</a>

</div>

<div id="catalogue">

## 学习 C 语言



### C 语言程序设计——现代方法 导读

这一部分的内容主要摘录自 《C 语言程序设计——现代方法》

1. [C语言概述](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/01-C%E8%AF%AD%E8%A8%80%E6%A6%82%E8%AE%BA.md)
2. [C语言基本概念1](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/02-C%E8%AF%AD%E8%A8%80%E5%9F%BA%E6%9C%AC%E6%A6%82%E5%BF%B5.md)
3. [C语言基本概念2](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/03-C%E8%AF%AD%E8%A8%80%E5%9F%BA%E6%9C%AC%E6%A6%82%E5%BF%B5.md)
4. [格式化输入输出](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/04-%E6%A0%BC%E5%BC%8F%E5%8C%96%E8%BE%93%E5%85%A5%E8%BE%93%E5%87%BA.md)
5. [数据类型](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/05-%E5%9F%BA%E6%9C%AC%E7%B1%BB%E5%9E%8B.md)
6. [表达式](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/06-%E8%A1%A8%E8%BE%BE%E5%BC%8F.md)
7. [选择语句](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/07-%E9%80%89%E6%8B%A9%E8%AF%AD%E5%8F%A5.md)
8. [循环](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/08-%E5%BE%AA%E7%8E%AF.md)
9. [数组](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/09-%E6%95%B0%E7%BB%84.md)
10. [函数](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/10-%E5%87%BD%E6%95%B0.md)
11. [程序结构](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/11-%E7%A8%8B%E5%BA%8F%E7%BB%93%E6%9E%84.md)
12. [指针](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/12-%E6%8C%87%E9%92%88.md)
13. [指针和数组](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/13-%E6%8C%87%E9%92%88%E5%92%8C%E6%95%B0%E7%BB%84.md)
14. [字符串](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/14-%E5%AD%97%E7%AC%A6%E4%B8%B2.md)
15. [预处理器](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/15-%E9%A2%84%E5%A4%84%E7%90%86%E5%99%A8.md)
16. [编写大型程序](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/16-%E7%BC%96%E5%86%99%E5%A4%A7%E5%9E%8B%E7%A8%8B%E5%BA%8F.md)
17. [结构&联合&枚举](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/17-%E7%BB%93%E6%9E%84%26%E8%81%94%E5%90%88%26%E6%9E%9A%E4%B8%BE.md)
18. [指针的高级应用](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/18-%E6%8C%87%E9%92%88%E7%9A%84%E9%AB%98%E7%BA%A7%E5%BA%94%E7%94%A8.md)
19. [声明](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/19-%E5%A3%B0%E6%98%8E.md)
20. [程序设计](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/20-%E7%A8%8B%E5%BA%8F%E8%AE%BE%E8%AE%A1.md)
21. [底层程序设计](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/21-%E5%BA%95%E5%B1%82%E7%A8%8B%E5%BA%8F%E8%AE%BE%E8%AE%A1.md)
22. [输入/输出](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/22-%E8%BE%93%E5%87%BA%26%E8%BE%93%E5%87%BA.md)
23. [标准库](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/23-%E6%A0%87%E5%87%86%E5%BA%93.md)
24. [错误处理](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-mordern-approch/24-%E9%94%99%E8%AF%AF%E5%A4%84%E7%90%86.md)

</div>

C 语言初阶和进阶的内容来自我的博客

### C 语言初阶

这一部分是我对 C 语言的基础知识部分的总结。

1. [数据类型和变量](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/1-%E6%95%B0%E6%8D%AE%E7%B1%BB%E5%9E%8B%E5%92%8C%E5%8F%98%E9%87%8F.md)
2. [数组](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/2-%E6%95%B0%E7%BB%84.md)
3. [分支和循环](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/3-%E5%88%86%E6%94%AF%E5%92%8C%E5%BE%AA%E7%8E%AF.md)
4. [函数](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/4-%E5%87%BD%E6%95%B0.md)
5. [指针](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/5-%E6%8C%87%E9%92%88.md)
6. [操作符](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-review/6-%E6%93%8D%E4%BD%9C%E7%AC%A6.md)

### C 语言进阶

1. [5分钟看懂什么是 malloc](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/5%E5%88%86%E9%92%9F%E7%9C%8B%E6%87%82%E4%BB%80%E4%B9%88%E6%98%AF%20malloc.md)
2. [C语言 文件 看这一篇就够了](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/C%E8%AF%AD%E8%A8%80%20%E6%96%87%E4%BB%B6%20%E7%9C%8B%E8%BF%99%E4%B8%80%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86.md)
3. [一篇看懂 C语言常用 字符串函数，全网最全整理](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E4%B8%80%E7%AF%87%E7%9C%8B%E6%87%82%20C%E8%AF%AD%E8%A8%80%E5%B8%B8%E7%94%A8%20%E5%AD%97%E7%AC%A6%E4%B8%B2%E5%87%BD%E6%95%B0%EF%BC%8C%E5%85%A8%E7%BD%91%E6%9C%80%E5%85%A8%E6%95%B4%E7%90%86%EF%BC%81.md)
4. [什么 是 枚举 & 结构 & 联合，看这一篇就够了](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E4%BB%80%E4%B9%88%20%E6%98%AF%20%E6%9E%9A%E4%B8%BE%20%26%20%E7%BB%93%E6%9E%84%20%26%20%E8%81%94%E5%90%88%EF%BC%8C%E7%9C%8B%E8%BF%99%E4%B8%80%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86.md)
5. [什么是 全局变量 & 宏 & 大程序怎么写，看这一篇就够了](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E4%BB%80%E4%B9%88%E6%98%AF%20%E5%85%A8%E5%B1%80%E5%8F%98%E9%87%8F%20%26%20%E5%AE%8F%20%26%20%E5%A4%A7%E7%A8%8B%E5%BA%8F%E6%80%8E%E4%B9%88%E5%86%99%EF%BC%8C%E7%9C%8B%E8%BF%99%E4%B8%80%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86.md)
6. [你不知道的几种素数判断方法，由浅入深，详解.](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E4%BD%A0%E4%B8%8D%E7%9F%A5%E9%81%93%E7%9A%84%E5%87%A0%E7%A7%8D%E7%B4%A0%E6%95%B0%E5%88%A4%E6%96%AD%E6%96%B9%E6%B3%95%EF%BC%8C%E7%94%B1%E6%B5%85%E5%85%A5%E6%B7%B1%EF%BC%8C%E8%AF%A6%E8%A7%A3.md)
7. [关于字符串你不知道的知识点](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E5%85%B3%E4%BA%8E%E5%AD%97%E7%AC%A6%E4%B8%B2%E4%BD%A0%E4%B8%8D%E7%9F%A5%E9%81%93%E7%9A%84%E7%9F%A5%E8%AF%86%E7%82%B9.md)
8. [内存对齐](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E5%86%85%E5%AD%98%E5%AF%B9%E9%BD%90.md)
9. [动态内存管理](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E5%8A%A8%E6%80%81%E5%86%85%E5%AD%98%E7%AE%A1%E7%90%86.md)
10. [字符串函数与内存函数](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E5%AD%97%E7%AC%A6%E4%B8%B2%E5%87%BD%E6%95%B0%E4%B8%8E%E5%86%85%E5%AD%98%E5%87%BD%E6%95%B0.md)
11. [小端和整型存储](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E5%B0%8F%E7%AB%AF%E5%92%8C%E6%95%B4%E5%9E%8B%E5%AD%98%E5%82%A8.md)
12. [指针进阶](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E6%8C%87%E9%92%88%E8%BF%9B%E9%98%B6.md)
13. [有关指针](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E6%9C%89%E5%85%B3%E6%8C%87%E9%92%88.md)
14. [浅谈 C 语言实现重载，多态和模板](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E6%B5%85%E8%B0%88%20C%20%E8%AF%AD%E8%A8%80%E5%AE%9E%E7%8E%B0%E9%87%8D%E8%BD%BD%EF%BC%8C%E5%A4%9A%E6%80%81%E5%92%8C%E6%A8%A1%E6%9D%BF.md)
15. [这些关于数组的基础知识点你都知道吗](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E8%BF%99%E4%BA%9B%E5%85%B3%E4%BA%8E%E6%95%B0%E7%BB%84%E7%9A%84%E5%9F%BA%E7%A1%80%E7%9F%A5%E8%AF%86%E7%82%B9%E4%BD%A0%E9%83%BD%E7%9F%A5%E9%81%93%E5%90%97.md)
16. [那些关于函数我们容易忽略的基础知识](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-notes/%E9%82%A3%E4%BA%9B%E5%85%B3%E4%BA%8E%E5%87%BD%E6%95%B0%E6%88%91%E4%BB%AC%E5%AE%B9%E6%98%93%E5%BF%BD%E7%95%A5%E7%9A%84%E5%9F%BA%E7%A1%80%E7%9F%A5%E8%AF%86.md)



### C 陷阱与缺陷

这一部分内容来自 《C 陷阱与缺陷》，看完这本书我对我之前犯的错误一种醍醐灌顶的感觉。

- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/01%20%E8%AF%8D%E6%B3%95%E9%99%B7%E9%98%B1.md">一 词法陷阱</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/02%20%E8%AF%AD%E6%B3%95%E9%99%B7%E9%98%B1.md">二 语法陷阱</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/03%20%E8%AF%AD%E4%B9%89%E9%99%B7%E9%98%B1.md">三 语义陷阱</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/04%20%E8%BF%9E%E6%8E%A5.md">四 连接</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/05%20%E5%BA%93%E5%87%BD%E6%95%B0.md">五 库函数</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/06%20%E9%A2%84%E5%A4%84%E7%90%86%E5%99%A8.md">六 预处理器</a>
- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/07%20%E5%8F%AF%E7%A7%BB%E6%A4%8D%E6%80%A7%E7%BC%BA%E9%99%B7.md">七 可移植缺陷</a>
- [八 建议](https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-traps-and-pitfalls/08%20%E5%BB%BA%E8%AE%AE.md)




</div>

<br>

### C 经典练习题

***

<div id="practice">


| 练习                                                         | 介绍                                                         | 难度                                              |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------- |
| **1**.[常见字符串/内存函数实现](./Coding/Practice/string)    | 主要实现：`strlen/strcpy/strcmp/strcat/strstr/memcpy/memmove` | :star::star::star:                                |
| **2**.[账簿计算](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/06%20%E5%BE%AA%E7%8E%AF/01%20%E8%B4%A6%E7%B0%BF%E8%AE%A1%E7%AE%97) | 练习循环的使用（`while, switch`）                            | :star:                                            |
| **3**.[计算利息 && 发牌](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/08%20%E6%95%B0%E7%BB%84) | 练习数组的使用                                               | :star:                                            |
| **4**.[判定素数](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/09%20%E5%87%BD%E6%95%B0/01%20%E5%88%A4%E5%AE%9A%E7%B4%A0%E6%95%B0) | 练习函数的使用                                               | :star:                                            |
| **5**.[猜数 && 手牌分类](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/10%20%E7%A8%8B%E5%BA%8F%E7%BB%93%E6%9E%84) | 练习全局变量的使用（拓展：如何取代全局变量）                 | :star:(猜数) ​      :star::star::star:（手牌分类） |
| **6**.[数组的最大元素和最小元素](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/11%20%E6%8C%87%E9%92%88/01%20%E6%95%B0%E7%BB%84%E7%9A%84%E6%9C%80%E5%A4%A7%E5%85%83%E7%B4%A0%E5%92%8C%E6%9C%80%E5%B0%8F%E5%85%83%E7%B4%A0) | 了解指针                                                     | :star:                                            |
| **7**.[设计字符串读取函数](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/13%20%E5%AD%97%E7%AC%A6%E4%B8%B2/01%20%E8%AE%BE%E8%AE%A1%E5%AD%97%E7%AC%A6%E4%B8%B2%E8%AF%BB%E5%8F%96%E5%87%BD%E6%95%B0) | 了解字符串的读取函数 `getchar`，字符串的特性（`\0` 结尾），`EOF` 的含义 | :star:                                            |
| **8**.[显示一个月的提醒](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/13%20%E5%AD%97%E7%AC%A6%E4%B8%B2/02%20%E6%98%BE%E7%A4%BA%E4%B8%80%E4%B8%AA%E6%9C%88%E7%9A%84%E6%8F%90%E9%86%92%E5%88%97%E8%A1%A8) | 了解字符串函数 `strcpy/strcat/strcmp` 的使用，并结合数组（二维）的知识 | :star::star:                                      |
| **10**.[核对行星名字](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/13%20%E5%AD%97%E7%AC%A6%E4%B8%B2/03%20%E6%A0%B8%E5%AF%B9%E8%A1%8C%E6%98%9F%E5%90%8D%E5%AD%97) | 了解（字符串）指针数组，`main` 函数的参数的含义              | :star::star:                                      |
| **11**.[文本格式化](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/15%20%E7%BC%96%E5%86%99%E5%A4%A7%E5%9E%8B%E7%A8%8B%E5%BA%8F/01%20%E6%96%87%E6%9C%AC%E6%A0%BC%E5%BC%8F%E5%8C%96) | 编写第一个多文件程序                                         | :star::star::star:                                |
| **12**.[维护零件数据库](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/16%20%E7%BB%93%E6%9E%84%26%E8%81%94%E5%90%88%26%E6%9E%9A%E4%B8%BE/01%20%E7%BB%B4%E6%8A%A4%E9%9B%B6%E4%BB%B6%E6%95%B0%E6%8D%AE%E5%BA%93) | 了解结构体及其使用                                           | ⭐️⭐️⭐️                                               |
| **13**.[显示一个月的提醒 pro](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/17%20%E6%8C%87%E9%92%88%E7%9A%84%E9%AB%98%E7%BA%A7%E5%BA%94%E7%94%A8/01%20%E6%98%BE%E7%A4%BA%E4%B8%80%E4%B8%AA%E6%9C%88%E7%9A%84%E6%8F%90%E9%86%92%E5%88%97%E8%A1%A8) | 了解动态内存分配函数 `malloc`                                | :star::star:                                      |
| **14**.[维护零件数据库 pro](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/17%20%E6%8C%87%E9%92%88%E7%9A%84%E9%AB%98%E7%BA%A7%E5%BA%94%E7%94%A8/02%20%E7%BB%B4%E6%8A%A4%E9%9B%B6%E4%BB%B6%E6%95%B0%E6%8D%AE%E5%BA%93%EF%BC%88%E9%93%BE%E8%A1%A8%EF%BC%89) | 了解链表这种数据结构                                         | ⭐️⭐️⭐️                                               |
| **15**.[栈实现](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/19%20%E7%A8%8B%E5%BA%8F%E8%AE%BE%E8%AE%A1/01%20%E6%A0%88%E7%9A%84%E5%AE%9E%E7%8E%B0/01%20%E6%A0%88%E6%A8%A1%E5%9D%97) | 数组实现和链表实现                                           | :star::star:                                      |
| **16**.[栈抽象数据类型](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/19%20%E7%A8%8B%E5%BA%8F%E8%AE%BE%E8%AE%A1/01%20%E6%A0%88%E7%9A%84%E5%AE%9E%E7%8E%B0/02%20%E6%A0%88%E6%8A%BD%E8%B1%A1%E6%95%B0%E6%8D%AE%E7%B1%BB%E5%9E%8B) | 了解抽象数据类型（ADT）                                      | ⭐️⭐️⭐️                                               |
| **17**.[XOR 加密 && 查看内存单元](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/20%20%E5%BA%95%E5%B1%82%E7%A8%8B%E5%BA%8F%E8%AE%BE%E8%AE%A1) | 了解底层程序设计（位运算等）                                 | :star::star:                                      |
| **18**.[输入输出](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/22%20%E8%BE%93%E5%85%A5%26%E8%BE%93%E5%87%BA) | 了解 C 语言输入输出，文件操作（`fopen/fclose`,`fread/fwrite`等） | :star::star:                                      |
| **19**.[错误处理](https://github.com/hairrrrr/C-CrashCourse/tree/master/Coding/C_Crash_Course/01%20Examples/24%20%E9%94%99%E8%AF%AF%E5%A4%84%E7%90%86) | 简单了解 `signal`，`setjump/longjump` 等函数的含义           | :star::star:                                      |
|                                                              |                                                              |                                                   |
|                                                              |                                                              |                                                   |
|                                                              |                                                              |                                                   |

</div>

</br>






<div id="game">

### 用 C 实现的小游戏

***

- <a href="https://github.com/hairrrrr/C-CrashCourse/blob/master/content/c-games/%E7%8C%9C%E6%95%B0%E5%AD%97.md">猜数</a>

<a href=""></a>

</div>



</div>

<br>

### C 课程设计作业

***

<div id="exam">

- <a href="https://mp.weixin.qq.com/s/qC0o0Gd7fxFGaCpbJKPdBQ">通讯录（基于文件）</a>
- <a href="https://mp.weixin.qq.com/s/qen0ub82GCcF4s7RiE0C0A">信息管理系统（基于文件）</a>

<a href=""></a>

</div>

<br>





## 参考资料
以下排名不分先后，感谢这些优秀的作者，老师和网站。
- 浙大·翁恺 mooc
- 《C 语言程序设计——现代方法》
- 《C Primer Plus》
- 《C 陷阱与缺陷》
- 《C 专家编程》
- www.cppreference.com
- www.cplusplus.com



## 免费获取 C 语言必读经典电子书

<div id="get">
如果侵权，请联系我的邮箱 shepardwang2020@outlook.com，我会第一时间删除

下面的书已经收集，并且本仓库还在持续增加电子书。如果对你有帮助，请点一个 star ~ ，让更多的人获得帮助。

- 《C 语言程序设计——现代方法》
- 《C Primer Plus》
- 《C primer Plus 第五版课后习题答案》
- 《C 陷阱与缺陷》
- 《C 专家编程》
- 《C 和 指针》
- 《C 程序设计》（谭浩强）

获取方式：**关注微信公众号【不会编程的程序圆】** ，后台回复  **【cbook】** ，即可获得下载链接

</div>




